/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.StreamFlags;
import java.util.Set;

public final class DcpOpenStreamRequest
extends Enum<DcpOpenStreamRequest> {
    private static final /* synthetic */ DcpOpenStreamRequest[] $VALUES;

    public static DcpOpenStreamRequest[] values() {
        return (DcpOpenStreamRequest[])$VALUES.clone();
    }

    public static DcpOpenStreamRequest valueOf(String name) {
        return Enum.valueOf(DcpOpenStreamRequest.class, name);
    }

    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == -128 && buffer.getByte(1) == 83;
    }

    public static void init(ByteBuf buffer, Set<StreamFlags> flags, int vbucket) {
        MessageUtil.initRequest((byte)83, buffer);
        MessageUtil.setVbucket(vbucket, buffer);
        MessageUtil.setExtras(Unpooled.buffer((int)48).writeInt(StreamFlags.encode(flags)).writeInt(0).writeLong(0L).writeLong(0L).writeLong(0L).writeLong(0L).writeLong(0L), buffer);
    }

    public static void startSeqno(ByteBuf buffer, long seqnoStart) {
        MessageUtil.getExtras(buffer).setLong(8, seqnoStart);
    }

    public static void endSeqno(ByteBuf buffer, long seqnoEnd) {
        MessageUtil.getExtras(buffer).setLong(16, seqnoEnd);
    }

    public static void vbuuid(ByteBuf buffer, long uuid) {
        MessageUtil.getExtras(buffer).setLong(24, uuid);
    }

    public static void snapshotStartSeqno(ByteBuf buffer, long snapshotSeqnoStart) {
        MessageUtil.getExtras(buffer).setLong(32, snapshotSeqnoStart);
    }

    public static void snapshotEndSeqno(ByteBuf buffer, long snapshotSeqnoEnd) {
        MessageUtil.getExtras(buffer).setLong(40, snapshotSeqnoEnd);
    }

    public static void opaque(ByteBuf buffer, int opaque) {
        MessageUtil.setOpaque(opaque, buffer);
    }

    public static int flags(ByteBuf buffer) {
        return MessageUtil.getExtras(buffer).getInt(0);
    }

    public static void flags(ByteBuf buffer, int flags) {
        MessageUtil.getExtras(buffer).setInt(0, flags);
    }

    public static void takeover(ByteBuf buffer) {
        DcpOpenStreamRequest.flags(buffer, DcpOpenStreamRequest.flags(buffer) | StreamFlags.TAKEOVER.value());
    }

    public static void diskOnly(ByteBuf buffer) {
        DcpOpenStreamRequest.flags(buffer, DcpOpenStreamRequest.flags(buffer) | StreamFlags.DISK_ONLY.value());
    }

    public static void latest(ByteBuf buffer) {
        DcpOpenStreamRequest.flags(buffer, DcpOpenStreamRequest.flags(buffer) | StreamFlags.LATEST.value());
    }

    public static void noValue(ByteBuf buffer) {
        DcpOpenStreamRequest.flags(buffer, DcpOpenStreamRequest.flags(buffer) | StreamFlags.NO_VALUE.value());
    }

    public static void activeVbucketOnly(ByteBuf buffer) {
        DcpOpenStreamRequest.flags(buffer, DcpOpenStreamRequest.flags(buffer) | StreamFlags.ACTIVE_VB_ONLY.value());
    }

    public static void strictVbucketUuid(ByteBuf buffer) {
        DcpOpenStreamRequest.flags(buffer, DcpOpenStreamRequest.flags(buffer) | StreamFlags.STRICT_VB_UUID.value());
    }

    private static /* synthetic */ DcpOpenStreamRequest[] $values() {
        return new DcpOpenStreamRequest[0];
    }

    static {
        $VALUES = DcpOpenStreamRequest.$values();
    }
}

