/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import java.util.EnumSet;
import java.util.Set;

public enum StreamFlags {
    TAKEOVER(1),
    DISK_ONLY(2),
    LATEST(4),
    NO_VALUE(8),
    ACTIVE_VB_ONLY(16),
    STRICT_VB_UUID(32);

    private final int value;

    private StreamFlags(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public boolean isSet(int flags) {
        return (flags & this.value) == this.value;
    }

    public static int encode(Set<StreamFlags> flags) {
        int result = 0;
        for (StreamFlags f : flags) {
            result |= f.value();
        }
        return result;
    }

    public static Set<StreamFlags> decode(int flags) {
        EnumSet<StreamFlags> result = EnumSet.noneOf(StreamFlags.class);
        for (StreamFlags f : StreamFlags.values()) {
            if (!f.isSet(flags)) continue;
            result.add(f);
        }
        return result;
    }
}

