/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelOutboundHandlerAdapter;
import com.couchbase.client.core.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.dcp.transport.netty.HandshakeDeadlineEvent;
import java.net.SocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeTimeoutHandler
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(HandshakeTimeoutHandler.class);
    private static final HandshakeDeadlineEvent HANDSHAKE_DEADLINE_EVENT = new HandshakeDeadlineEvent();
    private final long timeout;
    private final TimeUnit timeoutUnit;

    public HandshakeTimeoutHandler(long timeout, TimeUnit timeoutUnit) {
        this.timeout = timeout;
        this.timeoutUnit = Objects.requireNonNull(timeoutUnit);
    }

    public void connect(final ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
        ctx.pipeline().remove((ChannelHandler)this);
        Runnable fireDeadlineEvent = new Runnable(){

            @Override
            public void run() {
                LOGGER.debug("Firing handshake deadline event.");
                ctx.fireUserEventTriggered((Object)HANDSHAKE_DEADLINE_EVENT);
            }
        };
        LOGGER.debug("Handshake timeout is {} {}.", (Object)this.timeout, (Object)this.timeoutUnit);
        ctx.executor().schedule(fireDeadlineEvent, this.timeout, this.timeoutUnit);
    }
}

