/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.config;

import com.couchbase.client.core.logging.RedactableArgument;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HostAndPort {
    private final String host;
    private final int port;
    private final int hashCode;
    private final String formatted;
    private final String redactedFormatted;
    private static final Pattern hostAndPortPattern = Pattern.compile("(?<host>[^:]+)(:(?<port>\\d+))?");
    private static final Pattern hostAndPortPatternIpv6 = Pattern.compile("\\[(?<host>.+)](:(?<port>\\d+))?");

    public HostAndPort(String host, int port) {
        Objects.requireNonNull(host, "host must be non-null");
        boolean ipv6Literal = host.contains(":");
        this.host = ipv6Literal ? HostAndPort.canonicalizeIpv6Literal(host) : host;
        this.port = port;
        this.hashCode = Objects.hash(this.host, this.port);
        this.formatted = (ipv6Literal ? "[" + this.host + "]" : this.host) + (this.port <= 0 ? "" : ":" + this.port);
        this.redactedFormatted = RedactableArgument.redactSystem((Object)this.formatted).toString();
    }

    private static String canonicalizeIpv6Literal(String ipv6Literal) {
        return new InetSocketAddress(ipv6Literal, 0).getHostString();
    }

    @Deprecated
    public String hostname() {
        return this.host();
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public HostAndPort withPort(int port) {
        return this.port == port ? this : new HostAndPort(this.host, port);
    }

    public String format() {
        return this.formatted;
    }

    public static HostAndPort parse(String s) {
        return HostAndPort.parse(s, 0);
    }

    public static HostAndPort parse(String s, int defaultPort) {
        Pattern pattern = (s = s.trim()).startsWith("[") ? hostAndPortPatternIpv6 : hostAndPortPattern;
        Matcher m = pattern.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("Malformed address: " + s);
        }
        String portString = m.group("port");
        int port = portString == null ? defaultPort : Integer.parseInt(portString);
        return new HostAndPort(m.group("host"), port);
    }

    public String toString() {
        return this.redactedFormatted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAndPort that = (HostAndPort)o;
        return this.port == that.port && this.host.equals(that.host);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

