/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.dcp.core.config.BucketCapability;
import com.couchbase.client.dcp.core.config.ClusterCapability;
import com.couchbase.client.dcp.core.config.ClusterConfig;
import com.couchbase.client.dcp.core.config.ConfigRevision;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.config.PartitionMap;
import com.couchbase.client.dcp.core.service.ServiceType;
import com.couchbase.client.dcp.core.utils.CbCollections;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class CouchbaseBucketConfig {
    static final int PARTITION_NOT_EXISTENT = -2;
    private final ClusterConfig clusterConfig;
    private final String name;
    private final String uuid;
    private final boolean ephemeral;
    private final Set<BucketCapability> capabilities;
    private final int replicas;
    private final PartitionMap partitions;
    private final Optional<PartitionMap> partitionsForward;
    private final Set<String> primaryPartitionHosts;

    public CouchbaseBucketConfig(ClusterConfig clusterConfig, String name, String uuid, Set<BucketCapability> capabilities, boolean ephemeral, int replicas, PartitionMap partitions, @Nullable PartitionMap partitionsForward) {
        this.clusterConfig = Objects.requireNonNull(clusterConfig);
        this.name = Objects.requireNonNull(name);
        this.uuid = Objects.requireNonNull(uuid);
        this.replicas = replicas;
        this.partitions = Objects.requireNonNull(partitions);
        this.partitionsForward = Optional.ofNullable(partitionsForward);
        this.capabilities = Collections.unmodifiableSet(CbCollections.newEnumSet(BucketCapability.class, capabilities));
        this.ephemeral = ephemeral;
        this.primaryPartitionHosts = Collections.unmodifiableSet(partitions.values().stream().map(it -> it.active().map(NodeInfo::host).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public ConfigRevision revision() {
        return this.globalConfig().revision();
    }

    public List<NodeInfo> nodes() {
        return this.globalConfig().nodes();
    }

    public ClusterConfig globalConfig() {
        return this.clusterConfig;
    }

    public String name() {
        return this.name;
    }

    public String uuid() {
        return this.uuid;
    }

    public Set<BucketCapability> capabilities() {
        return this.capabilities;
    }

    public Set<ClusterCapability> clusterCapabilities() {
        return this.globalConfig().capabilities();
    }

    public boolean hasCapability(BucketCapability capability) {
        return this.capabilities.contains((Object)capability);
    }

    public boolean hasCapability(ClusterCapability capability) {
        return this.clusterConfig.hasCapability(capability);
    }

    public boolean ephemeral() {
        return this.ephemeral;
    }

    public int numberOfPartitions() {
        return this.partitions.size();
    }

    public int numberOfReplicas() {
        return this.replicas;
    }

    public PartitionMap partitions() {
        return this.partitions;
    }

    public Optional<PartitionMap> partitionsForward() {
        return this.partitionsForward;
    }

    private PartitionMap partitions(boolean forward) {
        return forward ? this.partitionsForward().orElseThrow(() -> new IllegalStateException("Config has no forward partition map.")) : this.partitions();
    }

    @Deprecated
    public boolean hasPrimaryPartitionsOnNode(String hostname) {
        return this.primaryPartitionHosts.contains(hostname);
    }

    @Deprecated
    public int nodeIndexForActive(int partition, boolean forward) {
        return this.partitions(forward).get(partition).nodeIndexForActive().orElse(-2);
    }

    @Deprecated
    public int nodeIndexForReplica(int partition, int replica, boolean forward) {
        return this.partitions(forward).get(partition).nodeIndexForReplica(replica).orElse(-2);
    }

    @Deprecated
    boolean serviceEnabled(ServiceType serviceType) {
        return this.nodes().stream().anyMatch(it -> it.has(serviceType));
    }

    @Deprecated
    public NodeInfo nodeAtIndex(int nodeIndex) {
        return this.nodes().get(nodeIndex);
    }

    public String toString() {
        return "CouchbaseBucketConfig{clusterConfig=" + this.clusterConfig + ", name='" + this.name + '\'' + ", uuid='" + this.uuid + '\'' + ", ephemeral=" + this.ephemeral + ", capabilities=" + this.capabilities + ", replicas=" + this.replicas + ", partitions=" + this.partitions + ", partitionsForward=" + this.partitionsForward + ", primaryPartitionHosts=" + this.primaryPartitionHosts + '}';
    }
}

