/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.highlevel.DatabaseChangeListener;
import com.couchbase.client.dcp.highlevel.internal.CollectionsManifest;
import com.couchbase.client.dcp.highlevel.internal.DatabaseChangeEvent;
import com.couchbase.client.dcp.message.DcpSystemEvent;
import com.couchbase.client.dcp.message.MessageUtil;

public class ScopeCreated
extends DcpSystemEvent
implements DcpSystemEvent.CollectionsManifestEvent,
DatabaseChangeEvent {
    private final long newManifestId;
    private final long scopeId;
    private final String scopeName;

    public ScopeCreated(int vbucket, long seqno, int version, ByteBuf buffer) {
        super(DcpSystemEvent.Type.SCOPE_CREATED, vbucket, seqno, version);
        this.scopeName = MessageUtil.getKeyAsString(buffer);
        ByteBuf value = MessageUtil.getContent(buffer);
        this.newManifestId = value.readLong();
        this.scopeId = value.readUnsignedInt();
    }

    @Override
    public long getManifestId() {
        return this.newManifestId;
    }

    public long getScopeId() {
        return this.scopeId;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    @Override
    public CollectionsManifest apply(CollectionsManifest currentManifest) {
        return currentManifest.withScope(this.newManifestId, this.scopeId, this.scopeName);
    }

    @Override
    public void dispatch(DatabaseChangeListener listener) {
        listener.onScopeCreated(this);
    }

    public String toString() {
        return "ScopeCreated{newManifestId=" + this.newManifestId + ", scopeId=" + this.scopeId + ", scopeName='" + this.scopeName + '\'' + ", vbucket=" + this.getVbucket() + ", seqno=" + this.getSeqno() + ", version=" + this.getVersion() + '}';
    }
}

