/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.metrics;

import com.couchbase.client.dcp.metrics.LogLevel;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventCounter {
    private final String name;
    private final Counter counter;
    private final MeterRegistry registry;
    private final List<Tag> baseTags;
    private final LogLevel logLevel;
    private final Logger logger;

    public static Builder builder(MeterRegistry registry, String name) {
        return new Builder(registry, name);
    }

    private EventCounter(MeterRegistry registry, String name, Iterable<Tag> tags, LogLevel logLevel) {
        this.registry = Objects.requireNonNull(registry);
        this.name = Objects.requireNonNull(name);
        this.logLevel = Objects.requireNonNull(logLevel);
        this.logger = LoggerFactory.getLogger((String)(EventCounter.class.getName() + "." + name));
        ArrayList tagList = new ArrayList();
        tags.forEach(tagList::add);
        this.baseTags = Collections.unmodifiableList(tagList);
        this.counter = registry.counter(name, this.baseTags);
    }

    public void increment() {
        this.logLevel.log(this.logger, "event {}", (Object)this.baseTags);
        this.counter.increment();
    }

    public void increment(long amount) {
        if (this.logLevel.isEnabled(this.logger)) {
            this.logLevel.log(this.logger, "event {} {}", (Object)amount, (Object)this.baseTags);
        }
        this.counter.increment((double)amount);
    }

    public static class Builder {
        private final String name;
        private final MeterRegistry registry;
        private List<Tag> baseTags = new ArrayList<Tag>();
        private LogLevel logLevel = LogLevel.INFO;

        private Builder(MeterRegistry registry, String name) {
            this.registry = Objects.requireNonNull(registry);
            this.name = Objects.requireNonNull(name);
        }

        public Builder tag(String key, String value) {
            return this.tag(Tag.of((String)key, (String)value));
        }

        public Builder tag(Tag tag) {
            this.baseTags.add(Objects.requireNonNull(tag));
            return this;
        }

        public Builder tags(Iterable<Tag> tag) {
            tag.forEach(this::tag);
            return this;
        }

        public Builder logLevel(LogLevel logLevel) {
            this.logLevel = Objects.requireNonNull(logLevel);
            return this;
        }

        public EventCounter build() {
            return new EventCounter(this.registry, this.name, this.baseTags, this.logLevel);
        }
    }
}

