/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.state;

import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnore;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.dcp.highlevel.SnapshotMarker;
import com.couchbase.client.dcp.highlevel.StreamOffset;
import com.couchbase.client.dcp.highlevel.internal.CollectionsManifest;
import com.couchbase.client.dcp.highlevel.internal.KeyExtractor;
import com.couchbase.client.dcp.state.FailoverLogEntry;
import com.couchbase.client.dcp.util.MathUtils;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import reactor.util.annotation.Nullable;

public class PartitionState {
    @JsonProperty(value="flog")
    private volatile List<FailoverLogEntry> failoverLog = new CopyOnWriteArrayList<FailoverLogEntry>();
    @JsonProperty(value="ss")
    private volatile long startSeqno = 0L;
    @JsonProperty(value="es")
    private volatile long endSeqno = 0L;
    private volatile SnapshotMarker snapshot = SnapshotMarker.NONE;
    @JsonProperty(value="cm")
    private volatile long collectionsManifestUid;
    private volatile CollectionsManifest collectionsManifest;
    private volatile KeyExtractor keyExtractor;
    @JsonIgnore
    private volatile StreamOffset mostRecentOpenStreamOffset;

    public static PartitionState fromOffset(StreamOffset offset) {
        PartitionState ps = new PartitionState();
        ps.setStartSeqno(offset.getSeqno());
        ps.setEndSeqno(-1L);
        ps.setSnapshot(offset.getSnapshot());
        ps.setCollectionsManifestUid(offset.getCollectionsManifestUid());
        ps.setFailoverLog(Collections.singletonList(new FailoverLogEntry(-1L, offset.getVbuuid())));
        return ps;
    }

    public long getCollectionsManifestUid() {
        return this.collectionsManifestUid;
    }

    public void setCollectionsManifestUid(long collectionsManifestUid) {
        this.collectionsManifestUid = collectionsManifestUid;
    }

    @JsonIgnore
    public CollectionsManifest getCollectionsManifest() {
        if (this.collectionsManifest == null) {
            throw new IllegalStateException("Collection manifest not yet set.");
        }
        return this.collectionsManifest;
    }

    public void setCollectionsManifest(CollectionsManifest collectionsManifest) {
        this.collectionsManifest = Objects.requireNonNull(collectionsManifest);
    }

    @JsonIgnore
    public KeyExtractor getKeyExtractor() {
        if (this.keyExtractor == null) {
            throw new IllegalStateException("Key extractor not yet set.");
        }
        return this.keyExtractor;
    }

    public void setKeyExtractor(KeyExtractor keyExtractor) {
        this.keyExtractor = keyExtractor;
    }

    public long getEndSeqno() {
        return this.endSeqno;
    }

    public long getStartSeqno() {
        return this.startSeqno;
    }

    public void setStartSeqno(long startSeqno) {
        this.startSeqno = startSeqno;
    }

    public void setEndSeqno(long endSeqno) {
        this.endSeqno = endSeqno;
    }

    public List<FailoverLogEntry> getFailoverLog() {
        return this.failoverLog;
    }

    public void setFailoverLog(List<FailoverLogEntry> log) {
        this.failoverLog = new CopyOnWriteArrayList<FailoverLogEntry>(log);
    }

    @Deprecated
    public void addToFailoverLog(long seqno, long vbuuid) {
        this.failoverLog.add(new FailoverLogEntry(seqno, vbuuid));
    }

    @JsonProperty(value="sss")
    public long getSnapshotStartSeqno() {
        return this.snapshot.getStartSeqno();
    }

    @Deprecated
    public void setSnapshotStartSeqno(long snapshotStartSeqno) {
        this.snapshot = new SnapshotMarker(snapshotStartSeqno, this.snapshot.getEndSeqno());
    }

    @JsonIgnore
    public void setSnapshot(SnapshotMarker snapshot) {
        this.snapshot = Objects.requireNonNull(snapshot);
    }

    @JsonIgnore
    public SnapshotMarker getSnapshot() {
        return this.snapshot;
    }

    @JsonProperty(value="ses")
    public long getSnapshotEndSeqno() {
        return this.snapshot.getEndSeqno();
    }

    @Deprecated
    public void setSnapshotEndSeqno(long snapshotEndSeqno) {
        this.snapshot = new SnapshotMarker(this.snapshot.getStartSeqno(), snapshotEndSeqno);
    }

    @JsonIgnore
    public boolean isAtEnd() {
        return !MathUtils.lessThanUnsigned(this.startSeqno, this.endSeqno);
    }

    @JsonIgnore
    public long getLastUuid() {
        return this.failoverLog.isEmpty() ? 0L : this.failoverLog.get(0).getUuid();
    }

    @JsonIgnore
    public StreamOffset getOffset() {
        return new StreamOffset(this.getLastUuid(), this.getStartSeqno(), this.getSnapshot(), this.getCollectionsManifestUid());
    }

    @Nullable
    public StreamOffset getMostRecentOpenStreamOffset() {
        return this.mostRecentOpenStreamOffset;
    }

    public void setMostRecentOpenStreamOffset(@Nullable StreamOffset offset) {
        this.mostRecentOpenStreamOffset = offset;
    }

    public String toString() {
        return "{log=" + this.failoverLog + ", ss=" + this.startSeqno + ", es=" + this.endSeqno + ", cm=" + this.collectionsManifestUid + ", sss=" + this.getSnapshotStartSeqno() + ", ses=" + this.getSnapshotEndSeqno() + '}';
    }
}

