/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.dcp.config.Control;
import com.couchbase.client.dcp.config.DcpControl;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import com.couchbase.client.dcp.message.DcpControlRequest;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.transport.netty.ConnectInterceptingHandler;
import com.couchbase.client.dcp.transport.netty.DcpConnectHandler;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DcpControlHandler
extends ConnectInterceptingHandler<ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(DcpControlHandler.class);
    private Iterator<Control> remainingControls;
    private Control currentControl;
    private final List<Control> negotiatedControls = new ArrayList<Control>();
    private final DcpControl dcpControl;

    DcpControlHandler(DcpControl dcpControl) {
        this.dcpControl = dcpControl;
    }

    private void negotiate(ChannelHandlerContext ctx) {
        if (this.remainingControls.hasNext()) {
            this.currentControl = this.remainingControls.next();
            log.debug("Negotiating DCP Control {}", (Object)this.currentControl);
            ByteBuf request = ctx.alloc().buffer();
            DcpControlRequest.init(request);
            DcpControlRequest.key(this.currentControl.name(), request);
            DcpControlRequest.value(Unpooled.copiedBuffer((CharSequence)this.currentControl.value(), (Charset)StandardCharsets.UTF_8), request);
            ctx.writeAndFlush((Object)request);
        } else {
            log.info("DCP control negotiation complete for node {} ; {}", (Object)RedactableArgument.redactSystem(ctx.channel().remoteAddress()), this.negotiatedControls);
            this.originalPromise().setSuccess();
            ctx.pipeline().remove((ChannelHandler)this);
            ctx.fireChannelActive();
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.remainingControls = this.dcpControl.getControls(DcpConnectHandler.getServerVersion(ctx.channel())).iterator();
        this.negotiate(ctx);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        ResponseStatus status = MessageUtil.getResponseStatus(msg);
        if (status.isSuccess()) {
            this.negotiatedControls.add(this.currentControl);
            log.debug("Successfully negotiated DCP control: {}", (Object)this.currentControl);
        } else if ((status == ResponseStatus.INVALID_ARGUMENTS || status == ResponseStatus.NOT_SUPPORTED) && this.currentControl.isOptional()) {
            log.debug("Server rejected optional DCP control: {} ; status = {}", (Object)this.currentControl, (Object)status);
        } else {
            this.originalPromise().setFailure((Throwable)new RuntimeException("Failed to negotiate DCP control: " + this.currentControl + " ; status = " + status));
            return;
        }
        this.negotiate(ctx);
    }
}

