/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.TextNode;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.dcp.core.config.ClusterCapability;
import com.couchbase.client.dcp.core.config.ClusterConfig;
import com.couchbase.client.dcp.core.config.ConfigRevision;
import com.couchbase.client.dcp.core.config.NetworkSelector;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.config.NodeInfoParser;
import com.couchbase.client.dcp.core.config.PortSelector;
import com.couchbase.client.dcp.core.utils.CbCollections;
import com.couchbase.client.dcp.core.utils.JacksonHelper;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterConfigParser {
    private static final TypeReference<Map<String, Set<String>>> SET_MULTIMAP_TYPE = new TypeReference<Map<String, Set<String>>>(){};

    private ClusterConfigParser() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static ClusterConfig parse(ObjectNode clusterConfig, String originHost, PortSelector portSelector, NetworkSelector networkSelector) {
        ArrayNode nodesExt = (ArrayNode)clusterConfig.get("nodesExt");
        if (nodesExt == null) {
            throw new CouchbaseException("Couchbase Server version is too old for this SDK; missing 'nodesExt' field.");
        }
        List<Map<NetworkResolution, NodeInfo>> nodes = JacksonHelper.transform(nodesExt, node -> NodeInfoParser.parse(ClusterConfigParser.addHostnameIfMissing(node, originHost), portSelector));
        NetworkResolution resolvedNetwork = networkSelector.selectNetwork(nodes).orElse(NetworkResolution.DEFAULT);
        List<NodeInfo> resolvedNodes = CbCollections.transform(nodes, it -> it.getOrDefault(resolvedNetwork, NodeInfo.INACCESSIBLE));
        return new ClusterConfig(ConfigRevision.parse(clusterConfig), resolvedNodes, ClusterConfigParser.parseCapabilities(clusterConfig), resolvedNetwork);
    }

    private static ObjectNode addHostnameIfMissing(JsonNode node, String originHost) {
        ObjectNode obj = (ObjectNode)node;
        if (!node.has("hostname") && node.path("thisNode").asBoolean()) {
            obj.set("hostname", (JsonNode)new TextNode(originHost));
        }
        return obj;
    }

    private static Set<ClusterCapability> parseCapabilities(ObjectNode clusterConfig) {
        JsonNode capabilitiesNode = clusterConfig.get("clusterCapabilities");
        if (capabilitiesNode == null) {
            return Collections.emptySet();
        }
        Map<String, Set<String>> map = JacksonHelper.convertValue(capabilitiesNode, SET_MULTIMAP_TYPE);
        EnumSet<ClusterCapability> result = EnumSet.noneOf(ClusterCapability.class);
        ClusterCapability.VALUES.forEach(it -> {
            if (map.getOrDefault(it.namespace(), Collections.emptySet()).contains(it.wireName())) {
                result.add((ClusterCapability)((Object)it));
            }
        });
        return result;
    }
}

