/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.config.PortSelector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import reactor.util.annotation.Nullable;

public class NodeInfoParser {
    private NodeInfoParser() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static Map<NetworkResolution, NodeInfo> parse(ObjectNode json, PortSelector portSelector) {
        HashMap<NetworkResolution, NodeInfo> result = new HashMap<NetworkResolution, NodeInfo>();
        NodeInfo defaultConfig = NodeInfoParser.parseOne(json, "services", portSelector);
        result.put(NetworkResolution.DEFAULT, defaultConfig);
        ObjectNode alternatesNode = (ObjectNode)json.get("alternateAddresses");
        if (alternatesNode == null) {
            return result;
        }
        alternatesNode.fields().forEachRemaining(it -> {
            NetworkResolution network = NetworkResolution.valueOf((String)((String)it.getKey()));
            NodeInfo alternate = NodeInfoParser.parseOne((ObjectNode)it.getValue(), "ports", portSelector);
            alternate = alternate.withMissingInfoFrom(defaultConfig);
            result.put(network, alternate);
        });
        return result;
    }

    private static NodeInfo parseOne(ObjectNode json, String portsFieldName, PortSelector portSelector) {
        String host = json.path("hostname").textValue();
        if (host == null) {
            throw new CouchbaseException("Couchbase server version is too old for this SDK; nodesExt entry is missing 'hostname' field.");
        }
        return new NodeInfo(host, NodeInfoParser.parseServices((ObjectNode)json.get(portsFieldName), portSelector));
    }

    private static Map<ServiceType, Integer> parseServices(@Nullable ObjectNode servicesNode, PortSelector portSelector) {
        if (servicesNode == null) {
            return Collections.emptyMap();
        }
        HashMap<ServiceType, Integer> serviceToPort = new HashMap<ServiceType, Integer>();
        servicesNode.fields().forEachRemaining(serviceField -> {
            String serviceName = (String)serviceField.getKey();
            portSelector.getServiceForName(serviceName).ifPresent(serviceType -> {
                JsonNode portNode = (JsonNode)serviceField.getValue();
                serviceToPort.put((ServiceType)serviceType, portNode.intValue());
            });
        });
        return serviceToPort;
    }
}

