/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.utils.CbCollections;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public interface NetworkSelector {
    public static final NetworkSelector DEFAULT = NetworkSelector.create(NetworkResolution.DEFAULT, Collections.emptySet());
    public static final NetworkSelector EXTERNAL = NetworkSelector.create(NetworkResolution.EXTERNAL, Collections.emptySet());

    public Optional<NetworkResolution> selectNetwork(List<Map<NetworkResolution, NodeInfo>> var1);

    public static NetworkSelector create(NetworkResolution network, Set<SeedNode> seedNodes) {
        return network.equals((Object)NetworkResolution.AUTO) ? new AutoNetworkSelector(seedNodes) : nodes -> Optional.of(network);
    }

    public static NetworkSelector autoDetect(Set<SeedNode> seedNodes) {
        return NetworkSelector.create(NetworkResolution.AUTO, seedNodes);
    }

    public static class AutoNetworkSelector
    implements NetworkSelector {
        private final Set<SeedNode> seedNodes;
        private Optional<NetworkResolution> cachedResult;

        public AutoNetworkSelector(Set<SeedNode> seedNodes) {
            this.seedNodes = CbCollections.copyToUnmodifiableSet(seedNodes);
        }

        @Override
        public synchronized Optional<NetworkResolution> selectNetwork(List<Map<NetworkResolution, NodeInfo>> nodes) {
            if (this.cachedResult == null) {
                this.cachedResult = this.doSelectNetwork(nodes);
            }
            return this.cachedResult;
        }

        private Optional<NetworkResolution> doSelectNetwork(List<Map<NetworkResolution, NodeInfo>> nodes) {
            for (Map<NetworkResolution, NodeInfo> node : nodes) {
                for (Map.Entry<NetworkResolution, NodeInfo> entry : node.entrySet()) {
                    for (SeedNode seedNode : this.seedNodes) {
                        if (!entry.getValue().matches(seedNode)) continue;
                        return Optional.of(entry.getKey());
                    }
                }
            }
            return Optional.empty();
        }
    }
}

