/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel;

import com.couchbase.client.dcp.highlevel.DatabaseChangeListener;
import com.couchbase.client.dcp.highlevel.SnapshotMarker;
import com.couchbase.client.dcp.highlevel.internal.DatabaseChangeEvent;
import com.couchbase.client.dcp.message.SnapshotMarkerFlag;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class SnapshotDetails
implements DatabaseChangeEvent {
    private static final List<SnapshotMarkerFlag> flagValues = Collections.unmodifiableList(Arrays.asList(SnapshotMarkerFlag.values()));
    private final int vbucket;
    private final int flags;
    private final SnapshotMarker marker;

    public SnapshotDetails(int vbucket, int flags, SnapshotMarker marker) {
        this.vbucket = vbucket;
        this.flags = flags;
        this.marker = marker;
    }

    @Override
    public void dispatch(DatabaseChangeListener listener) {
        listener.onSnapshot(this);
    }

    @Override
    public int getVbucket() {
        return this.vbucket;
    }

    public Set<SnapshotMarkerFlag> getFlags() {
        return SnapshotMarkerFlag.decode(this.flags);
    }

    public int getFlagsAsInt() {
        return this.flags;
    }

    public SnapshotMarker getMarker() {
        return this.marker;
    }
}

