/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.dcp.core.config.BucketConfig;
import com.couchbase.client.dcp.core.config.ClusterCapability;
import com.couchbase.client.dcp.core.config.ConfigRevision;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.utils.CbCollections;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import reactor.util.annotation.Nullable;

public class ClusterConfig {
    private final ConfigRevision revision;
    private final List<NodeInfo> nodes;
    private final Set<ClusterCapability> capabilities;
    private final NetworkResolution network;
    @Nullable
    private final BucketConfig bucket;

    public ClusterConfig(ConfigRevision revision, List<NodeInfo> nodes, Set<ClusterCapability> capabilities, NetworkResolution network, @Nullable BucketConfig bucket) {
        if (network.equals((Object)NetworkResolution.AUTO)) {
            throw new IllegalArgumentException("Must resolve 'auto' network before creating config.");
        }
        this.revision = Objects.requireNonNull(revision);
        this.nodes = CbCollections.copyToUnmodifiableList((Collection)Objects.requireNonNull(nodes));
        this.capabilities = Collections.unmodifiableSet(CbCollections.newEnumSet(ClusterCapability.class, capabilities));
        this.network = Objects.requireNonNull(network);
        this.bucket = bucket;
    }

    public ConfigRevision revision() {
        return this.revision;
    }

    public List<NodeInfo> nodes() {
        return this.nodes;
    }

    public NetworkResolution network() {
        return this.network;
    }

    public boolean hasCapability(ClusterCapability capability) {
        return this.capabilities.contains((Object)capability);
    }

    public Set<ClusterCapability> capabilities() {
        return this.capabilities;
    }

    @Nullable
    public BucketConfig bucket() {
        return this.bucket;
    }

    public String toString() {
        return "ClusterConfig{revision=" + this.revision + ", nodes=" + this.nodes + ", capabilities=" + this.capabilities + ", network=" + this.network + ", bucket=" + this.bucket + '}';
    }
}

