/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.dcp.core.config.AbstractBucketConfig;
import com.couchbase.client.dcp.core.config.BucketCapability;
import com.couchbase.client.dcp.core.config.CouchbaseBucketConfig;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.config.PartitionInfo;
import com.couchbase.client.dcp.core.config.PartitionMap;
import com.couchbase.client.dcp.core.utils.CbCollections;
import com.couchbase.client.dcp.core.utils.JacksonHelper;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import reactor.util.annotation.Nullable;

public class CouchbaseBucketConfigParser {
    private static final TypeReference<List<List<Integer>>> LIST_OF_LIST_OF_INTEGER_TYPE = new TypeReference<List<List<Integer>>>(){};

    public static CouchbaseBucketConfig parse(ObjectNode configNode, List<NodeInfo> nodes) {
        ObjectNode vBucketServerMap = (ObjectNode)configNode.get("vBucketServerMap");
        PartitionMap partitionMap = CouchbaseBucketConfigParser.parsePartitionMap(nodes, vBucketServerMap.get("vBucketMap")).orElse(PartitionMap.ABSENT);
        Optional<PartitionMap> partitionMapForward = CouchbaseBucketConfigParser.parsePartitionMap(nodes, vBucketServerMap.get("vBucketMapForward"));
        Set<BucketCapability> bucketCapabilities = AbstractBucketConfig.parseBucketCapabilities(configNode);
        boolean ephemeral = CouchbaseBucketConfigParser.parseEphemeral(configNode, bucketCapabilities);
        return new CouchbaseBucketConfig(configNode.path("name").asText(), configNode.path("uuid").asText(), bucketCapabilities, ephemeral, vBucketServerMap.path("numReplicas").asInt(0), partitionMap, partitionMapForward.orElse(null));
    }

    private static boolean parseEphemeral(ObjectNode configNode, Set<BucketCapability> bucketCapabilities) {
        String bucketType = configNode.path("bucketType").textValue();
        return bucketType != null ? "ephemeral".equals(bucketType) : !bucketCapabilities.contains((Object)BucketCapability.COUCHAPI);
    }

    private static Optional<PartitionMap> parsePartitionMap(List<NodeInfo> allNodes, @Nullable JsonNode vBucketMapNode) {
        if (vBucketMapNode == null) {
            return Optional.empty();
        }
        List<List<Integer>> vBucketMap = JacksonHelper.convertValue(vBucketMapNode, LIST_OF_LIST_OF_INTEGER_TYPE);
        List<PartitionInfo> entries = CbCollections.transform(vBucketMap, activeAndReplicaNodeIndexes -> PartitionInfo.parse(allNodes, activeAndReplicaNodeIndexes));
        return Optional.of(new PartitionMap(entries));
    }
}

