/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.time;

import com.couchbase.client.dcp.core.time.Delay;
import java.util.concurrent.TimeUnit;

public class LinearDelay
extends Delay {
    private final double growBy;
    private final long lower;
    private final long upper;

    LinearDelay(TimeUnit unit, long upper, long lower, double growBy) {
        super(unit);
        if (lower > upper) {
            throw new IllegalArgumentException("The lower value must be smaller or equal to the upper value!");
        }
        this.growBy = growBy;
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public long calculate(long attempt) {
        long calc = Math.round((double)attempt * this.growBy);
        if (calc < this.lower) {
            return this.lower;
        }
        if (calc > this.upper) {
            return this.upper;
        }
        return calc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LinearDelay{");
        sb.append("growBy ").append(this.growBy);
        sb.append(" " + (Object)((Object)this.unit()));
        sb.append("; lower=").append(this.lower);
        sb.append(", upper=").append(this.upper);
        sb.append('}');
        return sb.toString();
    }
}

