/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.utils;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.EventSubscription;
import com.couchbase.client.core.cnc.LoggingEventConsumer;
import java.time.Duration;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;

@Stability.Internal
public class MinimalEventBus
implements EventBus {
    public static final EventBus INSTANCE = new MinimalEventBus();
    private final LoggingEventConsumer loggingEventConsumer = LoggingEventConsumer.create();

    public synchronized EventBus.PublishResult publish(Event event) {
        this.loggingEventConsumer.accept(event);
        return EventBus.PublishResult.SUCCESS;
    }

    public EventSubscription subscribe(Consumer<Event> consumer) {
        throw new UnsupportedOperationException();
    }

    public void unsubscribe(EventSubscription subscription) {
        throw new UnsupportedOperationException();
    }

    public Mono<Void> start() {
        return Mono.empty();
    }

    public Mono<Void> stop(Duration timeout) {
        return Mono.empty();
    }
}

