/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import com.couchbase.client.dcp.highlevel.StreamOffset;
import com.couchbase.client.dcp.highlevel.internal.CollectionsManifest;
import com.couchbase.client.dcp.highlevel.internal.DatabaseChangeEvent;
import com.couchbase.client.dcp.highlevel.internal.FlowControlReceipt;
import com.couchbase.client.dcp.highlevel.internal.FlowControllable;
import com.couchbase.client.dcp.message.ContentAndXattrs;
import com.couchbase.client.dcp.message.DcpMutationMessage;
import com.couchbase.client.dcp.message.MessageUtil;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public abstract class DocumentChange
implements DatabaseChangeEvent,
FlowControllable {
    private static final long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static final AtomicLong nextTracingToken = new AtomicLong();
    private final long tracingToken = nextTracingToken.getAndIncrement();
    private final int vbucket;
    private final StreamOffset offset;
    private final ContentAndXattrs contentAndXattrs;
    private final boolean mutation;
    private final long revision;
    private final long cas;
    private final CollectionsManifest.CollectionInfo collectionInfo;
    private final String key;
    private final FlowControlReceipt receipt;

    public DocumentChange(ByteBuf byteBuf, CollectionsManifest.CollectionInfo collectionInfo, String key, FlowControlReceipt receipt, StreamOffset offset) {
        this.vbucket = MessageUtil.getVbucket(byteBuf);
        this.mutation = DcpMutationMessage.is(byteBuf);
        this.collectionInfo = Objects.requireNonNull(collectionInfo);
        this.key = Objects.requireNonNull(key);
        this.revision = DcpMutationMessage.revisionSeqno(byteBuf);
        this.offset = Objects.requireNonNull(offset);
        this.receipt = Objects.requireNonNull(receipt);
        this.contentAndXattrs = MessageUtil.getContentAndXattrs(byteBuf);
        this.cas = MessageUtil.getCas(byteBuf);
    }

    public long getTracingToken() {
        return this.tracingToken;
    }

    public Map<String, String> getXattrs() {
        return this.contentAndXattrs.xattrs();
    }

    public byte[] getContent() {
        return this.contentAndXattrs.content();
    }

    @Override
    public int getVbucket() {
        return this.vbucket;
    }

    public StreamOffset getOffset() {
        return this.offset;
    }

    public String getKey() {
        return this.key;
    }

    public String getQualifiedKey() {
        return this.collectionInfo.scope().name() + "." + this.collectionInfo.name() + "." + this.key;
    }

    public CollectionsManifest.CollectionInfo getCollection() {
        return this.collectionInfo;
    }

    public boolean isMutation() {
        return this.mutation;
    }

    public long getRevision() {
        return this.revision;
    }

    public long getCas() {
        return this.cas;
    }

    public Instant getTimestamp() {
        long epochNano = this.cas & 0xFFFFFFFFFFFF0000L;
        long epochSecond = Long.divideUnsigned(epochNano, NANOS_PER_SECOND);
        long nanoAdjustment = Long.remainderUnsigned(epochNano, NANOS_PER_SECOND);
        return Instant.ofEpochSecond(epochSecond, nanoAdjustment);
    }

    @Override
    public void flowControlAck() {
        this.receipt.acknowledge();
    }

    public String toString() {
        String type = this.isMutation() ? "MUT" : "DEL";
        return type + ":" + this.getVbucket() + "/" + this.getOffset() + "=" + RedactableArgument.user(this.getQualifiedKey());
    }
}

