/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.DeserializationFeature;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectReader;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.dcp.core.config.BucketCapability;
import com.couchbase.client.dcp.core.config.BucketConfig;
import com.couchbase.client.dcp.core.utils.CbCollections;
import com.couchbase.client.dcp.core.utils.JacksonHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Stability.Internal
public abstract class AbstractBucketConfig
implements BucketConfig {
    private final String name;
    private final String uuid;
    private final Set<BucketCapability> capabilities;
    private static final ObjectReader bucketCapabilitiesReader = JacksonHelper.reader().withFeatures(new DeserializationFeature[]{DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL}).forType((TypeReference)new TypeReference<Set<BucketCapability>>(){});

    public AbstractBucketConfig(String name, String uuid, Set<BucketCapability> capabilities) {
        this.name = Objects.requireNonNull(name);
        this.uuid = Objects.requireNonNull(uuid);
        this.capabilities = Collections.unmodifiableSet(CbCollections.newEnumSet(BucketCapability.class, capabilities));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String uuid() {
        return this.uuid;
    }

    @Override
    public Set<BucketCapability> capabilities() {
        return this.capabilities;
    }

    static Set<BucketCapability> parseBucketCapabilities(ObjectNode configNode) {
        JsonNode capabilitiesNode = configNode.get("bucketCapabilities");
        if (capabilitiesNode == null) {
            return Collections.emptySet();
        }
        try {
            Set result = (Set)bucketCapabilitiesReader.readValue(capabilitiesNode);
            return result.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new CouchbaseException("Failed to parse bucketCapabilities node: " + capabilitiesNode);
        }
    }
}

