/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Comparator;
import java.util.Objects;

public class ConfigRevision
implements Comparable<ConfigRevision> {
    public static final ConfigRevision ZERO = new ConfigRevision(0L, 0L);
    private static final Comparator<ConfigRevision> comparator = Comparator.comparing(ConfigRevision::epoch).thenComparing(ConfigRevision::rev);
    private final long epoch;
    private final long rev;

    public static ConfigRevision parse(ObjectNode json) {
        long epoch = json.path("revEpoch").longValue();
        JsonNode revNode = json.path("rev");
        if (!revNode.isIntegralNumber()) {
            throw new IllegalArgumentException("Missing or non-integer 'rev' field.");
        }
        return new ConfigRevision(epoch, revNode.longValue());
    }

    public ConfigRevision(long epoch, long rev) {
        if (rev < 0L) {
            throw new IllegalArgumentException("Config revision must be non-negative, but got " + rev);
        }
        this.epoch = epoch;
        this.rev = rev;
    }

    public long epoch() {
        return this.epoch;
    }

    public long rev() {
        return this.rev;
    }

    @Override
    public int compareTo(ConfigRevision o) {
        return comparator.compare(this, o);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigRevision that = (ConfigRevision)o;
        return this.epoch == that.epoch && this.rev == that.rev;
    }

    public String toString() {
        return this.epoch + "." + this.rev;
    }

    public int hashCode() {
        return Objects.hash(this.epoch, this.rev);
    }

    public boolean newerThan(ConfigRevision other) {
        return this.compareTo(other) > 0;
    }
}

