/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.StreamFlag;
import java.util.Set;

public final class DcpOpenStreamRequest
extends Enum<DcpOpenStreamRequest> {
    private static final /* synthetic */ DcpOpenStreamRequest[] $VALUES;

    public static DcpOpenStreamRequest[] values() {
        return (DcpOpenStreamRequest[])$VALUES.clone();
    }

    public static DcpOpenStreamRequest valueOf(String name) {
        return Enum.valueOf(DcpOpenStreamRequest.class, name);
    }

    public static boolean is(ByteBuf buffer) {
        return buffer.getByte(0) == -128 && buffer.getByte(1) == 83;
    }

    public static void init(ByteBuf buffer, Set<StreamFlag> flags, int vbucket) {
        MessageUtil.initRequest((byte)83, buffer);
        MessageUtil.setVbucket(vbucket, buffer);
        MessageUtil.setExtras(Unpooled.buffer((int)48).writeInt(StreamFlag.encode(flags)).writeInt(0).writeLong(0L).writeLong(0L).writeLong(0L).writeLong(0L).writeLong(0L), buffer);
    }

    public static void startSeqno(ByteBuf buffer, long seqnoStart) {
        MessageUtil.getExtras(buffer).setLong(8, seqnoStart);
    }

    public static void endSeqno(ByteBuf buffer, long seqnoEnd) {
        MessageUtil.getExtras(buffer).setLong(16, seqnoEnd);
    }

    public static void vbuuid(ByteBuf buffer, long uuid) {
        MessageUtil.getExtras(buffer).setLong(24, uuid);
    }

    public static void snapshotStartSeqno(ByteBuf buffer, long snapshotSeqnoStart) {
        MessageUtil.getExtras(buffer).setLong(32, snapshotSeqnoStart);
    }

    public static void snapshotEndSeqno(ByteBuf buffer, long snapshotSeqnoEnd) {
        MessageUtil.getExtras(buffer).setLong(40, snapshotSeqnoEnd);
    }

    public static void opaque(ByteBuf buffer, int opaque) {
        MessageUtil.setOpaque(opaque, buffer);
    }

    public static int flagsAsInt(ByteBuf buffer) {
        return MessageUtil.getExtras(buffer).getInt(0);
    }

    public static Set<StreamFlag> flags(ByteBuf buffer) {
        return StreamFlag.decode(DcpOpenStreamRequest.flagsAsInt(buffer));
    }

    public static void flags(ByteBuf buffer, int flags) {
        MessageUtil.getExtras(buffer).setInt(0, flags);
    }

    private static /* synthetic */ DcpOpenStreamRequest[] $values() {
        return new DcpOpenStreamRequest[0];
    }

    static {
        $VALUES = DcpOpenStreamRequest.$values();
    }
}

