/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.core.config.BucketCapability;
import com.couchbase.client.dcp.core.utils.CbCollections;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public enum StreamFlag {
    TAKEOVER(1, new BucketCapability[0]),
    DISK_ONLY(2, new BucketCapability[0]),
    LATEST(4, new BucketCapability[0]),
    NO_VALUE(8, new BucketCapability[0]),
    ACTIVE_VB_ONLY(16, new BucketCapability[0]),
    STRICT_VB_UUID(32, new BucketCapability[0]),
    FROM_LATEST(64, new BucketCapability[0]),
    IGNORE_PURGED_TOMBSTONES(128, BucketCapability.DCP_IGNORE_PURGED_TOMBSTONES);

    private final int value;
    private final Set<BucketCapability> requiredCapabilities;

    private StreamFlag(int value, BucketCapability ... requiredCapabilities) {
        this.value = value;
        this.requiredCapabilities = Collections.unmodifiableSet(CbCollections.newEnumSet(BucketCapability.class, Arrays.asList(requiredCapabilities)));
    }

    public int value() {
        return this.value;
    }

    public Set<BucketCapability> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public boolean isSet(int flags) {
        return (flags & this.value) == this.value;
    }

    public static int encode(Set<StreamFlag> flags) {
        int result = 0;
        for (StreamFlag f : flags) {
            result |= f.value();
        }
        return result;
    }

    public static Set<StreamFlag> decode(int flags) {
        EnumSet<StreamFlag> result = EnumSet.noneOf(StreamFlag.class);
        for (StreamFlag f : StreamFlag.values()) {
            if (!f.isSet(flags)) continue;
            result.add(f);
        }
        return result;
    }
}

