/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class PartitionSet {
    private static final String RANGE_DELIMITER = ";";
    private static final PartitionSet EMPTY = new PartitionSet(Collections.emptyList());
    private final List<ClosedIntRange> ranges;

    private PartitionSet(List<ClosedIntRange> ranges) {
        this.ranges = Collections.unmodifiableList(new ArrayList<ClosedIntRange>(ranges));
    }

    public static PartitionSet parse(String formatted) {
        if ((formatted = formatted.trim()).isEmpty()) {
            return EMPTY;
        }
        String[] ranges = formatted.split(Pattern.quote(RANGE_DELIMITER), -1);
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String range : ranges) {
            range = range.trim();
            result.addAll(ClosedIntRange.parse(range).toList());
        }
        return PartitionSet.from(result);
    }

    public static PartitionSet allPartitions(int numPartitions) {
        return new PartitionSet(Collections.singletonList(new ClosedIntRange(0, numPartitions - 1)));
    }

    public static PartitionSet from(Collection<Integer> values) {
        int currentRangeStart;
        if (values.isEmpty()) {
            return EMPTY;
        }
        ArrayList<ClosedIntRange> result = new ArrayList<ClosedIntRange>();
        TreeSet<Integer> sorted = new TreeSet<Integer>(values);
        Iterator iter = sorted.iterator();
        int prev = currentRangeStart = ((Integer)iter.next()).intValue();
        while (iter.hasNext()) {
            int current = (Integer)iter.next();
            if (current == prev + 1) {
                prev = current;
                continue;
            }
            result.add(new ClosedIntRange(currentRangeStart, prev));
            currentRangeStart = current;
            prev = current;
        }
        result.add(new ClosedIntRange(currentRangeStart, prev));
        return new PartitionSet(result);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionSet that = (PartitionSet)o;
        return this.ranges.equals(that.ranges);
    }

    public int hashCode() {
        return Objects.hash(this.ranges);
    }

    public List<Integer> toList() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (ClosedIntRange r : this.ranges) {
            result.addAll(r.toList());
        }
        return result;
    }

    public Set<Integer> toSet() {
        return new LinkedHashSet<Integer>(this.toList());
    }

    public String format() {
        return this.ranges.stream().map(ClosedIntRange::format).collect(Collectors.joining(RANGE_DELIMITER));
    }

    public String toString() {
        return this.format();
    }

    private static class ClosedIntRange {
        private static final String ENDPOINT_DELIMITER = "..";
        private final int start;
        private final int end;

        public ClosedIntRange(int singleValue) {
            this(singleValue, singleValue);
        }

        public ClosedIntRange(int start, int end) {
            if (start > end) {
                throw new IllegalArgumentException("Start must be <= end, but got start " + start + " and end " + end);
            }
            this.start = start;
            this.end = end;
        }

        public static ClosedIntRange parse(String range) {
            try {
                if (range.contains(ENDPOINT_DELIMITER)) {
                    String[] components = range.split(Pattern.quote(ENDPOINT_DELIMITER), -1);
                    if (components.length != 2) {
                        throw new IllegalArgumentException("Malformed ClosedIntRange. Expected lower..upper but got: " + range);
                    }
                    return new ClosedIntRange(Integer.parseInt(components[0].trim()), Integer.parseInt(components[1].trim()));
                }
                return new ClosedIntRange(Integer.parseInt(range));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Malformed ClosedIntRange. Expected integer or lower..upper but got: " + range, e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClosedIntRange that = (ClosedIntRange)o;
            return this.start == that.start && this.end == that.end;
        }

        public int hashCode() {
            return Objects.hash(this.start, this.end);
        }

        public List<Integer> toList() {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (int i = this.start; i <= this.end; ++i) {
                result.add(i);
            }
            return result;
        }

        public String toString() {
            return this.format();
        }

        public String format() {
            if (this.start == this.end) {
                return Integer.toString(this.start);
            }
            return this.start == this.end - 1 ? this.start + PartitionSet.RANGE_DELIMITER + this.end : this.start + ENDPOINT_DELIMITER + this.end;
        }
    }
}

