/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.config.PortSelector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import reactor.util.annotation.Nullable;

public class NodeInfoParser {
    private static final TypeReference<Map<String, Integer>> MAP_STRING_TO_INT = new TypeReference<Map<String, Integer>>(){};

    private NodeInfoParser() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static Map<NetworkResolution, NodeInfo> parse(ObjectNode json, PortSelector portSelector) {
        Map<NetworkResolution, HostAndRawServicePorts> raw = NodeInfoParser.parseIntermediate(json);
        HostAndPort ketamaAuthority = NodeInfoParser.getKetamaAuthority(raw);
        return CbCollections.transformValues(raw, value -> new NodeInfo(((HostAndRawServicePorts)value).host, portSelector.selectPorts(((HostAndRawServicePorts)value).rawServicePorts), ketamaAuthority));
    }

    @Nullable
    private static HostAndPort getKetamaAuthority(Map<NetworkResolution, HostAndRawServicePorts> networkToNodeInfo) {
        HostAndRawServicePorts defaultNodeMap = networkToNodeInfo.get(NetworkResolution.DEFAULT);
        if (defaultNodeMap == null) {
            return null;
        }
        Map<ServiceType, Integer> nonTlsPorts = PortSelector.NON_TLS.selectPorts(defaultNodeMap.rawServicePorts);
        Integer nonTlsKvPort = nonTlsPorts.get(ServiceType.KV);
        if (nonTlsKvPort == null) {
            return null;
        }
        return new HostAndPort(defaultNodeMap.host, nonTlsKvPort.intValue());
    }

    private static Map<NetworkResolution, HostAndRawServicePorts> parseIntermediate(ObjectNode json) {
        HashMap<NetworkResolution, HostAndRawServicePorts> result = new HashMap<NetworkResolution, HostAndRawServicePorts>();
        HostAndRawServicePorts defaultInfo = NodeInfoParser.parseOne(json, "services");
        result.put(NetworkResolution.DEFAULT, defaultInfo);
        json.path("alternateAddresses").fields().forEachRemaining(it -> {
            NetworkResolution network = NetworkResolution.valueOf((String)((String)it.getKey()));
            HostAndRawServicePorts alternate = NodeInfoParser.parseOne((ObjectNode)it.getValue(), "ports");
            if (alternate.rawServicePorts.isEmpty()) {
                alternate = new HostAndRawServicePorts(alternate.host, defaultInfo.rawServicePorts);
            }
            result.put(network, alternate);
        });
        return result;
    }

    private static HostAndRawServicePorts parseOne(ObjectNode json, String portsFieldName) {
        String host = json.path("hostname").textValue();
        if (host == null) {
            throw new CouchbaseException("Couchbase server version is too old for this SDK; nodesExt entry is missing 'hostname' field.");
        }
        return new HostAndRawServicePorts(host, NodeInfoParser.parseServices((ObjectNode)json.get(portsFieldName)));
    }

    private static Map<String, Integer> parseServices(@Nullable ObjectNode servicesNode) {
        return servicesNode == null ? Collections.emptyMap() : (Map)Mapper.convertValue((Object)servicesNode, MAP_STRING_TO_INT);
    }

    private static class HostAndRawServicePorts {
        private final String host;
        private final Map<String, Integer> rawServicePorts;

        public HostAndRawServicePorts(String host, Map<String, Integer> rawServicePorts) {
            this.host = Objects.requireNonNull(host);
            this.rawServicePorts = Objects.requireNonNull(rawServicePorts);
        }
    }
}

