/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import java.util.Objects;

public class ResponseStatus {
    private static final ResponseStatus[] values = new ResponseStatus[256];
    public static final ResponseStatus NO_ERROR = new ResponseStatus(0, "NO_ERROR", "No error");
    public static final ResponseStatus KEY_NOT_FOUND = new ResponseStatus(1, "KEY_NOT_FOUND", "Key not found");
    public static final ResponseStatus KEY_EXISTS = new ResponseStatus(2, "KEY_EXISTS", "Key exists");
    public static final ResponseStatus VALUE_TOO_LARGE = new ResponseStatus(3, "VALUE_TOO_LARGE", "Value too large");
    public static final ResponseStatus INVALID_ARGUMENTS = new ResponseStatus(4, "INVALID_ARGUMENTS", "Invalid arguments");
    public static final ResponseStatus ITEM_NOT_STORED = new ResponseStatus(5, "ITEM_NOT_STORED", "Item not stored");
    public static final ResponseStatus NON_NUMERIC = new ResponseStatus(6, "NON_NUMERIC", "Incr/Decr on a non-numeric value");
    public static final ResponseStatus NOT_MY_VBUCKET = new ResponseStatus(7, "NOT_MY_VBUCKET", "The vbucket belongs to another server");
    public static final ResponseStatus NOT_CONNECTED_TO_BUCKET = new ResponseStatus(8, "NOT_CONNECTED_TO_BUCKET", "The connection is not connected to a bucket");
    public static final ResponseStatus STALE_AUTH_CONTEXT = new ResponseStatus(31, "STALE_AUTH_CONTEXT", "The authentication context is stale, please re-authenticate");
    public static final ResponseStatus AUTH_ERROR = new ResponseStatus(32, "AUTH_ERROR", "Authentication error");
    public static final ResponseStatus AUTH_CONTINUE = new ResponseStatus(33, "AUTH_CONTINUE", "Authentication continue");
    public static final ResponseStatus ILLEGAL_RANGE = new ResponseStatus(34, "ILLEGAL_RANGE", "The requested value is outside the legal ranges");
    public static final ResponseStatus ROLLBACK_REQUIRED = new ResponseStatus(35, "ROLLBACK_REQUIRED", "Rollback required");
    public static final ResponseStatus NO_ACCESS = new ResponseStatus(36, "NO_ACCESS", "No access / insufficient permissions (or does not exist)");
    public static final ResponseStatus INITIALIZING_NODE = new ResponseStatus(37, "INITIALIZING_NODE", "The node is being initialized");
    public static final ResponseStatus UNKNOWN_COMMAND = new ResponseStatus(129, "UNKNOWN_COMMAND", "Unknown command");
    public static final ResponseStatus OUT_OF_MEMORY = new ResponseStatus(130, "OUT_OF_MEMORY", "Out of memory");
    public static final ResponseStatus NOT_SUPPORTED = new ResponseStatus(131, "NOT_SUPPORTED", "Not supported");
    public static final ResponseStatus INTERNAL_ERROR = new ResponseStatus(132, "INTERNAL_ERROR", "Internal error");
    public static final ResponseStatus BUSY = new ResponseStatus(133, "BUSY", "Busy");
    public static final ResponseStatus TEMPORARY_FAILURE = new ResponseStatus(134, "TEMPORARY_FAILURE", "Temporary Failure");
    public static final ResponseStatus XATTR_INVALID_SYNTAX = new ResponseStatus(135, "XATTR_INVALID_SYNTAX", "XATTR invalid syntax");
    public static final ResponseStatus UNKNOWN_COLLECTION = new ResponseStatus(136, "UNKNOWN_COLLECTION", "Unknown collection");
    public static final ResponseStatus NO_COLLECTIONS_MANIFEST = new ResponseStatus(137, "NO_COLLECTIONS_MANIFEST", "No collections manifest");
    public static final ResponseStatus COLLECTIONS_MANIFEST_NOT_APPLIED = new ResponseStatus(138, "COLLECTIONS_MANIFEST_NOT_APPLIED", "Collections manifest not applied");
    public static final ResponseStatus CLIENT_COLLECTIONS_MANIFEST_AHEAD = new ResponseStatus(139, "CLIENT_COLLECTIONS_MANIFEST_AHEAD", "Client collections manifest ahead");
    public static final ResponseStatus UNKNOWN_SCOPE = new ResponseStatus(140, "UNKNOWN_SCOPE", "Unknown scope");
    public static final ResponseStatus DURABILITY_LEVEL_INVALID = new ResponseStatus(160, "DURABILITY_LEVEL_INVALID", "Durability level invalid");
    public static final ResponseStatus DURABILITY_IMPOSSIBLE = new ResponseStatus(161, "DURABILITY_IMPOSSIBLE", "Durability impossible");
    public static final ResponseStatus SYNCHRONOUS_WRITE_IN_PROGRESS = new ResponseStatus(162, "SYNCHRONOUS_WRITE_IN_PROGRESS", "Synchronous write in progress");
    public static final ResponseStatus SYNCHRONOUS_WRITE_AMBIGUOUS = new ResponseStatus(163, "SYNCHRONOUS_WRITE_AMBIGUOUS", "Synchronous write ambiguous");
    private static final int MALFORMED_RESPONSE_CODE = -1;
    public static final ResponseStatus MALFORMED_RESPONSE = new ResponseStatus(-1, "MALFORMED_RESPONSE", "Malformed response");
    private final int code;
    private final String formatted;
    private final String symbolicName;

    public static ResponseStatus valueOf(int code) {
        ResponseStatus status;
        if ((code &= 0xFFFF) < 256 && (status = values[code]) != null) {
            return status;
        }
        return new ResponseStatus(code);
    }

    private ResponseStatus(int code, String symbolicName, String description) {
        this.code = code;
        this.formatted = ResponseStatus.format(code, description);
        this.symbolicName = Objects.requireNonNull(symbolicName);
        if (code == -1) {
            return;
        }
        if (values[code] != null) {
            throw new IllegalStateException("already initialized status " + values[code]);
        }
        ResponseStatus.values[code] = this;
    }

    private ResponseStatus(int code) {
        this.code = code;
        this.formatted = ResponseStatus.format(code, "???");
        this.symbolicName = String.format("0x%04x", code);
    }

    private static String format(int code, String message) {
        return String.format("0x%04x (%s)", code, message);
    }

    public int code() {
        return this.code;
    }

    public boolean isTemporary() {
        return this == BUSY || this == TEMPORARY_FAILURE;
    }

    public boolean isSuccess() {
        return this == NO_ERROR;
    }

    public String formatted() {
        return this.formatted;
    }

    public String symbolicName() {
        return this.symbolicName;
    }

    public String toString() {
        return this.formatted();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseStatus that = (ResponseStatus)o;
        return this.code == that.code;
    }

    public int hashCode() {
        return this.code;
    }
}

