/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.JsonProcessingException;
import com.couchbase.client.dcp.ClientVersion;
import com.couchbase.client.dcp.ConnectionIdGenerator;
import com.couchbase.client.dcp.ConnectionNameGenerator;
import com.couchbase.client.dcp.core.utils.CbStrings;
import com.couchbase.client.dcp.core.utils.DefaultObjectMapper;
import com.couchbase.client.dcp.util.UserAgentBuilder;
import java.io.IOException;
import java.util.LinkedHashMap;
import reactor.util.annotation.Nullable;

public class DefaultConnectionNameGenerator
implements ConnectionNameGenerator {
    public static final ConnectionNameGenerator INSTANCE = new DefaultConnectionNameGenerator(new UserAgentBuilder());
    private final ConnectionIdGenerator idGenerator = new ConnectionIdGenerator();
    private final String userAgent;
    private final String untruncatedUserAgent;

    public static DefaultConnectionNameGenerator forProduct(String productName, String productVersion, String ... comments) {
        return new DefaultConnectionNameGenerator(new UserAgentBuilder().append(productName, productVersion, comments));
    }

    private DefaultConnectionNameGenerator(UserAgentBuilder userAgentBuilder) {
        userAgentBuilder.append("java-dcp-client", ClientVersion.clientVersion(), new String[0]).appendJava().appendOs();
        this.untruncatedUserAgent = userAgentBuilder.build();
        int userAgentJsonMaxLength = 154;
        this.userAgent = DefaultConnectionNameGenerator.truncateAsJson(userAgentBuilder.build(), 154);
    }

    @Override
    public String name() {
        LinkedHashMap<String, String> name = new LinkedHashMap<String, String>();
        name.put("i", this.idGenerator.next());
        name.put("a", this.userAgent);
        try {
            return DefaultObjectMapper.writeValueAsString(name);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public static String extractConnectionId(String connectionName) {
        try {
            return DefaultObjectMapper.readTree(connectionName).path("i").textValue();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String truncateAsJson(String s, int maxSerializedLength) {
        char c;
        boolean charNeedsEscape;
        int resultLength = 0;
        int spaceLeft = maxSerializedLength - 2;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n && (spaceLeft -= (charNeedsEscape = (c = cArray[i]) == '\\' || c == '\"' || c == '\t') ? 2 : 1) >= 0; ++i) {
            ++resultLength;
        }
        return CbStrings.truncate(s, resultLength);
    }

    public String toString() {
        return "DefaultConnectionNameGenerator{userAgent='" + this.untruncatedUserAgent + '\'' + '}';
    }
}

