/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.buffer;

import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.topology.BucketCapability;
import com.couchbase.client.core.topology.ClusterTopologyWithBucket;
import com.couchbase.client.core.topology.CouchbaseBucketTopology;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.TopologyRevision;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.dcp.buffer.NodeToPartitionMultimap;
import com.couchbase.client.dcp.buffer.PartitionInstance;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;

public class DcpBucketConfig {
    private final ClusterTopologyWithBucket topology;
    private final CouchbaseBucketTopology bucket;
    private final NodeToPartitionMultimap map;
    private final List<HostAndServicePorts> allKvNodes;

    public DcpBucketConfig(ClusterTopologyWithBucket topology) {
        this.topology = Objects.requireNonNull(topology);
        this.bucket = (CouchbaseBucketTopology)topology.bucket();
        this.map = new NodeToPartitionMultimap(this.bucket);
        this.allKvNodes = Collections.unmodifiableList(topology.nodes().stream().filter(node -> node.has(ServiceType.KV)).collect(Collectors.toList()));
    }

    public TopologyRevision rev() {
        return this.topology.revision();
    }

    public int numberOfPartitions() {
        return this.bucket.partitions().size();
    }

    public List<HostAndServicePorts> nodes() {
        return this.allKvNodes;
    }

    public List<PartitionInstance> getHostedPartitions(HostAndPort nodeAddress) throws NoSuchElementException {
        int nodeIndex = this.getNodeIndex(nodeAddress);
        return this.map.get(nodeIndex);
    }

    public List<HostAndServicePorts> getKvNodes() {
        return this.allKvNodes;
    }

    public int getNodeIndex(HostAndPort nodeAddress) throws NoSuchElementException {
        int nodeIndex = 0;
        for (HostAndServicePorts node : this.nodes()) {
            if (nodeAddress.equals((Object)this.getAddress(node))) {
                return nodeIndex;
            }
            ++nodeIndex;
        }
        throw new NoSuchElementException("Failed to locate " + RedactableArgument.redactSystem(nodeAddress) + " in bucket config.");
    }

    public HostAndPort getActiveNodeKvAddress(int partition) {
        HostAndServicePorts node = (HostAndServicePorts)this.bucket.partitions().active(partition).orElseThrow(() -> new IllegalStateException("No active node for partition " + partition));
        return this.getAddress(node);
    }

    public List<PartitionInstance> getAbsentPartitionInstances() {
        return this.map.getAbsent();
    }

    public HostAndPort getAddress(HostAndServicePorts node) {
        return new HostAndPort(node.host(), node.port(ServiceType.KV).orElseThrow(() -> new IllegalArgumentException("Node not running KV service: " + node)));
    }

    public int numberOfReplicas() {
        return this.bucket.numberOfReplicas();
    }

    public boolean hasCapability(BucketCapability capability) {
        return this.bucket.hasCapability(capability);
    }
}

