/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.highlevel;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.dcp.highlevel.DatabaseChangeListener;
import com.couchbase.client.dcp.highlevel.internal.CollectionsManifest;
import com.couchbase.client.dcp.highlevel.internal.DatabaseChangeEvent;
import com.couchbase.client.dcp.message.DcpSystemEvent;
import com.couchbase.client.dcp.message.MessageUtil;
import java.util.OptionalLong;

public class CollectionCreated
extends DcpSystemEvent
implements DcpSystemEvent.CollectionsManifestEvent,
DatabaseChangeEvent {
    private final long newManifestId;
    private final long scopeId;
    private final long collectionId;
    private final String collectionName;
    private final OptionalLong maxTtl;

    public CollectionCreated(int vbucket, long seqno, int version, ByteBuf buffer) {
        super(DcpSystemEvent.Type.COLLECTION_CREATED, vbucket, seqno, version);
        this.collectionName = MessageUtil.getKeyAsString(buffer);
        ByteBuf value = MessageUtil.getContent(buffer);
        this.newManifestId = value.readLong();
        this.scopeId = value.readUnsignedInt();
        this.collectionId = value.readUnsignedInt();
        this.maxTtl = value.isReadable() ? OptionalLong.of(value.readUnsignedInt()) : OptionalLong.empty();
    }

    @Override
    public long getManifestId() {
        return this.newManifestId;
    }

    public long getScopeId() {
        return this.scopeId;
    }

    public long getCollectionId() {
        return this.collectionId;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public OptionalLong getMaxTtl() {
        return this.maxTtl;
    }

    @Override
    public CollectionsManifest apply(CollectionsManifest currentManifest) {
        Long maxTtl = this.maxTtl.isPresent() ? Long.valueOf(this.maxTtl.getAsLong()) : null;
        return currentManifest.withCollection(this.newManifestId, this.scopeId, this.collectionId, this.collectionName, maxTtl);
    }

    @Override
    public void dispatch(DatabaseChangeListener listener) {
        listener.onCollectionCreated(this);
    }

    public String toString() {
        return "CollectionCreated{newManifestId=" + this.newManifestId + ", scopeId=" + this.scopeId + ", collectionId=" + this.collectionId + ", collectionName='" + this.collectionName + '\'' + ", maxTtl=" + this.maxTtl + ", vbucket=" + this.getVbucket() + ", seqno=" + this.getSeqno() + ", version=" + this.getVersion() + '}';
    }
}

