/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.handler.ssl.SslHandler;
import com.couchbase.client.core.io.netty.kv.sasl.CouchbaseSaslClientFactory;
import com.couchbase.client.core.util.Bytes;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.dcp.Credentials;
import com.couchbase.client.dcp.core.endpoint.kv.AuthenticationException;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.message.SaslAuthRequest;
import com.couchbase.client.dcp.message.SaslAuthResponse;
import com.couchbase.client.dcp.message.SaslListMechsRequest;
import com.couchbase.client.dcp.message.SaslListMechsResponse;
import com.couchbase.client.dcp.message.SaslStepRequest;
import com.couchbase.client.dcp.message.SaslStepResponse;
import com.couchbase.client.dcp.transport.netty.ConnectInterceptingHandler;
import com.couchbase.client.dcp.transport.netty.DcpPipeline;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthHandler
extends ConnectInterceptingHandler<ByteBuf>
implements CallbackHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthHandler.class);
    private static final Set<String> secureSaslMechanisms = com.couchbase.client.dcp.core.utils.CbCollections.setOf("SCRAM-SHA1", "SCRAM-SHA256", "SCRAM-SHA512");
    private final Credentials credentials;
    private SaslClient saslClient;
    private String selectedMechanism;

    public AuthHandler(Credentials credentials) {
        this.credentials = Objects.requireNonNull(credentials);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        boolean tls;
        boolean bl = tls = ctx.pipeline().get(SslHandler.class) != null;
        if (tls) {
            LOGGER.debug("{} Using SASL mechanism PLAIN because connection is secure.", DcpPipeline.describe(ctx));
            this.selectMechanismAndStartAuth(ctx, CbCollections.listOf((Object[])new String[]{"PLAIN"}));
            return;
        }
        ByteBuf request = ctx.alloc().buffer();
        SaslListMechsRequest.init(request);
        this.send(ctx, request);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        if (SaslListMechsResponse.is(msg)) {
            this.handleListMechsResponse(ctx, msg);
        } else if (SaslAuthResponse.is(msg) || SaslStepResponse.is(msg)) {
            this.handleSaslResponse(ctx, msg);
        } else {
            throw new IllegalStateException("Received unexpected packet during SASL exchange! " + MessageUtil.humanize(msg));
        }
    }

    private void handleSaslResponse(ChannelHandlerContext ctx, ByteBuf msg) {
        block7: {
            try {
                ResponseStatus status = MessageUtil.getResponseStatus(msg);
                if (status.isSuccess()) {
                    if (!this.saslClient.isComplete()) {
                        byte[] serverFinal = MessageUtil.getContentAsByteArray(msg);
                        this.saslClient.evaluateChallenge(serverFinal);
                        if (!this.saslClient.isComplete()) {
                            throw new IllegalStateException("SASL exchange incomplete");
                        }
                    }
                    LOGGER.debug("{} Successfully authenticated", DcpPipeline.describe(ctx));
                    ctx.pipeline().remove((ChannelHandler)this);
                    this.originalPromise().setSuccess();
                    ctx.fireChannelActive();
                    break block7;
                }
                if (status == ResponseStatus.AUTH_CONTINUE) {
                    byte[] challenge = MessageUtil.getContentAsByteArray(msg);
                    byte[] challengeResponse = this.saslClient.evaluateChallenge(challenge);
                    ByteBuf request = ctx.alloc().buffer();
                    SaslStepRequest.init(request);
                    SaslStepRequest.mechanism(this.selectedMechanism, request);
                    SaslStepRequest.challengeResponse(challengeResponse, request);
                    this.send(ctx, request);
                    break block7;
                }
                if (status == ResponseStatus.AUTH_ERROR) {
                    throw new AuthenticationException("SASL Authentication Failure");
                }
                throw new AuthenticationException("Unhandled SASL auth status: " + status);
            }
            catch (Throwable t) {
                this.fail(t);
            }
        }
    }

    private void handleListMechsResponse(ChannelHandlerContext ctx, ByteBuf saslListMechsResponse) {
        try {
            List<String> advertisedMechanisms = SaslListMechsResponse.supportedMechs(saslListMechsResponse);
            if (advertisedMechanisms.isEmpty()) {
                throw new AuthenticationException("Server advertised no SASL mechanisms: " + RedactableArgument.system(ctx.channel().remoteAddress()));
            }
            ArrayList<String> negotiatedMechanisms = new ArrayList<String>(advertisedMechanisms);
            negotiatedMechanisms.retainAll(secureSaslMechanisms);
            if (negotiatedMechanisms.isEmpty()) {
                throw new AuthenticationException("Server advertised only insecure or unsupported SASL mechanisms: " + advertisedMechanisms + "; required one of " + secureSaslMechanisms + "; " + RedactableArgument.system(ctx.channel().remoteAddress()));
            }
            this.selectMechanismAndStartAuth(ctx, negotiatedMechanisms);
        }
        catch (Throwable t) {
            this.fail(t);
        }
    }

    private void selectMechanismAndStartAuth(ChannelHandlerContext ctx, List<String> supportedMechanisms) {
        try {
            String remote = ctx.channel().remoteAddress().toString();
            String[] mechanismArray = supportedMechanisms.toArray(new String[0]);
            this.saslClient = new CouchbaseSaslClientFactory().createSaslClient(mechanismArray, null, "couchbase", remote, null, (CallbackHandler)this);
            if (this.saslClient == null) {
                throw new AuthenticationException("Failed to create a SASL client for any of the negotiated mechanisms: " + supportedMechanisms);
            }
            this.selectedMechanism = this.saslClient.getMechanismName();
            LOGGER.debug("{} Selected SASL mechanism: {}", DcpPipeline.describe(ctx), (Object)this.selectedMechanism);
            byte[] payload = this.saslClient.hasInitialResponse() ? this.saslClient.evaluateChallenge(Bytes.EMPTY_BYTE_ARRAY) : Bytes.EMPTY_BYTE_ARRAY;
            ByteBuf request = ctx.alloc().buffer();
            SaslAuthRequest.init(request);
            SaslAuthRequest.mechanism(this.selectedMechanism, request);
            SaslAuthRequest.challengeResponse(payload, request);
            this.send(ctx, request);
        }
        catch (Throwable t) {
            this.fail(t);
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.credentials.getUsername());
                continue;
            }
            if (callback instanceof PasswordCallback) {
                ((PasswordCallback)callback).setPassword(this.credentials.getPassword().toCharArray());
                continue;
            }
            throw new AuthenticationException("SASLClient requested unsupported callback: " + callback);
        }
    }

    private void fail(Throwable cause) {
        this.originalPromise().setFailure(cause);
    }

    private void send(ChannelHandlerContext ctx, ByteBuf request) {
        ctx.writeAndFlush((Object)request).addListener(future -> {
            if (!future.isSuccess()) {
                LOGGER.warn("Error during SASL Auth negotiation phase.", future.cause());
                this.fail(future.cause());
            }
        });
    }
}

