/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;

public class Expression {
    private static final Expression NULL_INSTANCE = new Expression("NULL");
    private static final Expression TRUE_INSTANCE = new Expression(true);
    private static final Expression FALSE_INSTANCE = new Expression(false);
    private final Object value;

    private Expression(Object value) {
        this.value = value;
    }

    public static Expression x(String value) {
        return new Expression(value);
    }

    public static Expression s(String value) {
        return new Expression("\"" + value + "\"");
    }

    public static Expression x(int value) {
        return new Expression(value);
    }

    public static Expression x(long value) {
        return new Expression(value);
    }

    public static Expression x(boolean value) {
        return value ? TRUE_INSTANCE : FALSE_INSTANCE;
    }

    public static Expression x(JsonArray value) {
        return new Expression(value);
    }

    public static Expression x(JsonObject value) {
        return new Expression(value);
    }

    public static Expression TRUE() {
        return TRUE_INSTANCE;
    }

    public static Expression FALSE() {
        return FALSE_INSTANCE;
    }

    public static Expression NULL() {
        return NULL_INSTANCE;
    }

    public Expression not() {
        return Expression.prefix("NOT", this.toString());
    }

    public Expression and(Expression right) {
        return Expression.infix("AND", this.toString(), right.toString());
    }

    public Expression or(Expression right) {
        return Expression.infix("OR", this.toString(), right.toString());
    }

    public Expression eq(Expression right) {
        return Expression.infix("=", this.toString(), right.toString());
    }

    public Expression ne(Expression right) {
        return Expression.infix("!=", this.toString(), right.toString());
    }

    public Expression gt(Expression right) {
        return Expression.infix(">", this.toString(), right.toString());
    }

    public Expression lt(Expression right) {
        return Expression.infix("<", this.toString(), right.toString());
    }

    public Expression gte(Expression right) {
        return Expression.infix(">=", this.toString(), right.toString());
    }

    public Expression lte(Expression right) {
        return Expression.infix("<=", this.toString(), right.toString());
    }

    public Expression is(Expression right) {
        return Expression.infix("IS", this.toString(), right.toString());
    }

    public Expression between(Expression right) {
        return Expression.infix("BETWEEN", this.toString(), right.toString());
    }

    public Expression notBetween(Expression right) {
        return Expression.infix("NOT BETWEEN", this.toString(), right.toString());
    }

    public Expression like(Expression right) {
        return Expression.infix("LIKE", this.toString(), right.toString());
    }

    public Expression notLike(Expression right) {
        return Expression.infix("NOT LIKE", this.toString(), right.toString());
    }

    public Expression isValued() {
        return Expression.postfix("IS VALUED", this.toString());
    }

    public Expression isNotValued() {
        return Expression.postfix("IS NOT VALUED", this.toString());
    }

    public Expression isNull() {
        return Expression.postfix("IS NULL", this.toString());
    }

    public Expression isNotNull() {
        return Expression.postfix("IS NOT NULL", this.toString());
    }

    public Expression isMissing() {
        return Expression.postfix("IS MISSING", this.toString());
    }

    public Expression isNotMissing() {
        return Expression.postfix("IS NOT MISSING", this.toString());
    }

    public Expression concat(Expression right) {
        return Expression.infix("||", this.toString(), right.toString());
    }

    public Expression isNull(Expression right) {
        return Expression.infix("<=", this.toString(), right.toString());
    }

    public Expression exists() {
        return Expression.prefix("EXISTS", this.toString());
    }

    public Expression in(Expression right) {
        return Expression.infix("IN", this.toString(), right.toString());
    }

    public Expression notIn(Expression right) {
        return Expression.infix("NOT IN", this.toString(), right.toString());
    }

    public Expression as(String alias) {
        return Expression.infix("AS", this.toString(), alias);
    }

    private static Expression prefix(String prefix, String right) {
        return new Expression(prefix + " " + right);
    }

    private static Expression infix(String infix, String left, String right) {
        return new Expression(left + " " + infix + " " + right);
    }

    private static Expression postfix(String postfix, String left) {
        return new Expression(left + " " + postfix);
    }

    public String toString() {
        return this.value.toString();
    }
}

