/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.bucket;

import com.couchbase.client.java.bucket.BucketInfo;
import com.couchbase.client.java.bucket.BucketType;
import com.couchbase.client.java.document.json.JsonObject;

public class DefaultBucketInfo
implements BucketInfo {
    private final JsonObject raw;

    DefaultBucketInfo(JsonObject raw) {
        this.raw = raw;
    }

    public static DefaultBucketInfo create(JsonObject raw) {
        return new DefaultBucketInfo(raw);
    }

    @Override
    public String name() {
        return this.raw.getString("name");
    }

    @Override
    public BucketType type() {
        String type = this.raw.getString("bucketType");
        if (type.equals("membase")) {
            return BucketType.COUCHBASE;
        }
        return BucketType.MEMCACHED;
    }

    @Override
    public int nodeCount() {
        return this.raw.getArray("nodes").size();
    }

    @Override
    public int replicaCount() {
        return this.raw.getInt("replicaNumber");
    }

    @Override
    public JsonObject raw() {
        return this.raw;
    }

    public String toString() {
        return "DefaultBucketInfo{raw=" + this.raw + '}';
    }
}

