package com.couchbase.client.java.query;

import com.couchbase.client.java.document.json.JsonObject;
import rx.Observable;

/**
 * .
 *
 * @author Michael Nitschinger
 */
public interface AsyncQueryResult {

    Observable<AsyncQueryRow> rows();

    Observable<JsonObject> info();

    boolean parseSuccess();

    Observable<Boolean> finalSuccess();

    Observable<JsonObject> errors();

    /**
     * @return the requestId generated by the server
     */
    String requestId();

    /**
     * @return the clientContextId that was set by the client (could be truncated to 64 bytes of UTF-8 chars)
     */
    String clientContextId();
}
