/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.document.json;

import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.document.json.JsonValue;
import com.couchbase.client.java.transcoder.JacksonTransformers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class JsonArray
extends JsonValue
implements Iterable<Object> {
    private final List<Object> content = new ArrayList<Object>();

    private JsonArray() {
    }

    public static JsonArray empty() {
        return new JsonArray();
    }

    public static JsonArray create() {
        return new JsonArray();
    }

    public static JsonArray from(Object ... items) {
        JsonArray array = new JsonArray();
        for (Object item : items) {
            if (!JsonArray.checkType(item)) {
                throw new IllegalArgumentException("Unsupported type for JsonArray: " + item.getClass());
            }
            array.add(item);
        }
        return array;
    }

    public static JsonArray from(List<?> items) {
        if (items == null) {
            throw new NullPointerException("Null list unsupported");
        }
        if (items.isEmpty()) {
            return JsonArray.empty();
        }
        JsonArray array = new JsonArray();
        ListIterator<?> iter = items.listIterator();
        while (iter.hasNext()) {
            JsonValue sub;
            int i = iter.nextIndex();
            Object item = iter.next();
            if (item == JsonValue.NULL) {
                item = null;
            }
            if (item instanceof Map) {
                try {
                    sub = JsonObject.from((Map)item);
                    array.add((JsonObject)sub);
                    continue;
                }
                catch (ClassCastException e) {
                    throw e;
                }
                catch (Exception e) {
                    ClassCastException c = new ClassCastException("Couldn't convert sub-Map at " + i + " to JsonObject");
                    c.initCause(e);
                    throw c;
                }
            }
            if (item instanceof List) {
                try {
                    sub = JsonArray.from((List)item);
                    array.add((JsonArray)sub);
                    continue;
                }
                catch (Exception e) {
                    ClassCastException c = new ClassCastException("Couldn't convert sub-List at " + i + " to JsonArray");
                    c.initCause(e);
                    throw c;
                }
            }
            if (JsonArray.checkType(item)) {
                array.add(item);
                continue;
            }
            throw new IllegalArgumentException("Unsupported type for JsonArray: " + item.getClass());
        }
        return array;
    }

    public static JsonArray fromJson(String s) {
        try {
            return CouchbaseAsyncBucket.JSON_ARRAY_TRANSCODER.stringToJsonArray(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot convert string to JsonArray", e);
        }
    }

    public Object get(int index) {
        return this.content.get(index);
    }

    public JsonArray add(Object value) {
        if (value == this) {
            throw new IllegalArgumentException("Cannot add self");
        }
        if (value == JsonValue.NULL) {
            this.addNull();
        } else if (JsonArray.checkType(value)) {
            this.content.add(value);
        } else {
            throw new IllegalArgumentException("Unsupported type for JsonArray: " + value.getClass());
        }
        return this;
    }

    public JsonArray addNull() {
        this.content.add(null);
        return this;
    }

    public JsonArray add(String value) {
        this.content.add(value);
        return this;
    }

    public String getString(int index) {
        return (String)this.content.get(index);
    }

    public JsonArray add(long value) {
        this.content.add(value);
        return this;
    }

    public Long getLong(int index) {
        Number n = (Number)this.content.get(index);
        if (n == null) {
            return null;
        }
        if (n instanceof Long) {
            return (Long)n;
        }
        return n.longValue();
    }

    public JsonArray add(int value) {
        this.content.add(value);
        return this;
    }

    public Integer getInt(int index) {
        Number n = (Number)this.content.get(index);
        if (n == null) {
            return null;
        }
        if (n instanceof Integer) {
            return (Integer)n;
        }
        return n.intValue();
    }

    public JsonArray add(double value) {
        this.content.add(value);
        return this;
    }

    public Double getDouble(int index) {
        Number n = (Number)this.content.get(index);
        if (n == null) {
            return null;
        }
        if (n instanceof Double) {
            return (Double)n;
        }
        return n.doubleValue();
    }

    public JsonArray add(boolean value) {
        this.content.add(value);
        return this;
    }

    public boolean getBoolean(int index) {
        return (Boolean)this.content.get(index);
    }

    public JsonArray add(JsonObject value) {
        this.content.add(value);
        return this;
    }

    public JsonArray add(Map<String, ?> value) {
        return this.add(JsonObject.from(value));
    }

    public JsonObject getObject(int index) {
        return (JsonObject)this.content.get(index);
    }

    public JsonArray add(JsonArray value) {
        if (value == this) {
            throw new IllegalArgumentException("Cannot add self");
        }
        this.content.add(value);
        return this;
    }

    public JsonArray add(List<?> value) {
        return this.add(JsonArray.from(value));
    }

    public JsonArray getArray(int index) {
        return (JsonArray)this.content.get(index);
    }

    public List<Object> toList() {
        ArrayList<Object> copy = new ArrayList<Object>(this.content.size());
        for (Object o : this.content) {
            if (o instanceof JsonObject) {
                copy.add(((JsonObject)o).toMap());
                continue;
            }
            if (o instanceof JsonArray) {
                copy.add(((JsonArray)o).toList());
                continue;
            }
            copy.add(o);
        }
        return copy;
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public int size() {
        return this.content.size();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.content.iterator();
    }

    public String toString() {
        try {
            return JacksonTransformers.MAPPER.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot convert JsonArray to Json String", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonArray array = (JsonArray)o;
        return !(this.content != null ? !this.content.equals(array.content) : array.content != null);
    }

    public int hashCode() {
        return this.content.hashCode();
    }
}

