/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.view.OnError;
import com.couchbase.client.java.view.Stale;
import java.net.URLEncoder;

public class SpatialViewQuery {
    private static final int PARAM_LIMIT_OFFSET = 0;
    private static final int PARAM_SKIP_OFFSET = 2;
    private static final int PARAM_STALE_OFFSET = 4;
    private static final int PARAM_DEBUG_OFFSET = 6;
    private static final int PARAM_START_RANGE_OFFSET = 8;
    private static final int PARAM_END_RANGE_OFFSET = 10;
    private static final int PARAM_ONERROR_OFFSET = 12;
    private static final int NUM_PARAMS = 7;
    private final String[] params;
    private final String design;
    private final String view;
    private boolean development;

    private SpatialViewQuery(String design, String view) {
        this.design = design;
        this.view = view;
        this.params = new String[14];
    }

    public static SpatialViewQuery from(String design, String view) {
        return new SpatialViewQuery(design, view);
    }

    public SpatialViewQuery development() {
        return this.development(true);
    }

    public SpatialViewQuery development(boolean development) {
        this.development = development;
        return this;
    }

    public SpatialViewQuery limit(int limit) {
        if (limit < 0) {
            throw new IllegalArgumentException("Limit must be >= 0.");
        }
        this.params[0] = "limit";
        this.params[1] = Integer.toString(limit);
        return this;
    }

    public SpatialViewQuery skip(int skip) {
        if (skip < 0) {
            throw new IllegalArgumentException("Skip must be >= 0.");
        }
        this.params[2] = "skip";
        this.params[3] = Integer.toString(skip);
        return this;
    }

    public SpatialViewQuery stale(Stale stale) {
        this.params[4] = "stale";
        this.params[5] = stale.identifier();
        return this;
    }

    public SpatialViewQuery debug() {
        return this.debug(true);
    }

    public SpatialViewQuery debug(boolean debug) {
        this.params[6] = "debug";
        this.params[7] = Boolean.toString(debug);
        return this;
    }

    public SpatialViewQuery startRange(JsonArray startRange) {
        this.params[8] = "start_range";
        this.params[9] = startRange.toString();
        return this;
    }

    public SpatialViewQuery endRange(JsonArray endRange) {
        this.params[10] = "end_range";
        this.params[11] = endRange.toString();
        return this;
    }

    public SpatialViewQuery range(JsonArray startRange, JsonArray endRange) {
        this.startRange(startRange);
        this.endRange(endRange);
        return this;
    }

    public SpatialViewQuery onError(OnError onError) {
        this.params[12] = "on_error";
        this.params[13] = onError.identifier();
        return this;
    }

    protected String encode(String source) {
        try {
            return URLEncoder.encode(source, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not prepare view argument: " + ex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean firstParam = true;
        for (int i = 0; i < this.params.length; ++i) {
            boolean even;
            if (this.params[i] == null) {
                ++i;
                continue;
            }
            boolean bl = even = i % 2 == 0;
            if (even && !firstParam) {
                sb.append("&");
            }
            sb.append(this.params[i]);
            firstParam = false;
            if (!even) continue;
            sb.append('=');
        }
        return sb.toString();
    }

    public String getDesign() {
        return this.design;
    }

    public String getView() {
        return this.view;
    }

    public boolean isDevelopment() {
        return this.development;
    }
}

