/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.util.Blocking;
import com.couchbase.client.java.view.AsyncSpatialViewResult;
import com.couchbase.client.java.view.AsyncSpatialViewRow;
import com.couchbase.client.java.view.DefaultAsyncSpatialViewResult;
import com.couchbase.client.java.view.DefaultSpatialViewRow;
import com.couchbase.client.java.view.SpatialViewResult;
import com.couchbase.client.java.view.SpatialViewRow;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Func1;

public class DefaultSpatialViewResult
implements SpatialViewResult {
    private static final TimeUnit TIMEOUT_UNIT = TimeUnit.MILLISECONDS;
    private final AsyncSpatialViewResult asyncViewResult;
    private final long timeout;
    private final CouchbaseEnvironment env;
    private final Bucket bucket;

    public DefaultSpatialViewResult(CouchbaseEnvironment env, Bucket bucket, Observable<AsyncSpatialViewRow> rows, boolean success, JsonObject error, JsonObject debug) {
        this.asyncViewResult = new DefaultAsyncSpatialViewResult(rows, success, error, debug);
        this.timeout = env.viewTimeout();
        this.env = env;
        this.bucket = bucket;
    }

    @Override
    public List<SpatialViewRow> allRows() {
        return this.allRows(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public List<SpatialViewRow> allRows(long timeout, TimeUnit timeUnit) {
        return (List)Blocking.blockForSingle(this.asyncViewResult.rows().map((Func1)new Func1<AsyncSpatialViewRow, SpatialViewRow>(){

            public SpatialViewRow call(AsyncSpatialViewRow asyncViewRow) {
                return new DefaultSpatialViewRow(DefaultSpatialViewResult.this.env, DefaultSpatialViewResult.this.bucket, asyncViewRow.id(), asyncViewRow.key(), asyncViewRow.value(), asyncViewRow.geometry());
            }
        }).toList(), timeout, timeUnit);
    }

    @Override
    public Iterator<SpatialViewRow> rows() {
        return this.rows(this.timeout, TIMEOUT_UNIT);
    }

    @Override
    public Iterator<SpatialViewRow> rows(long timeout, TimeUnit timeUnit) {
        return this.asyncViewResult.rows().map((Func1)new Func1<AsyncSpatialViewRow, SpatialViewRow>(){

            public SpatialViewRow call(AsyncSpatialViewRow asyncViewRow) {
                return new DefaultSpatialViewRow(DefaultSpatialViewResult.this.env, DefaultSpatialViewResult.this.bucket, asyncViewRow.id(), asyncViewRow.key(), asyncViewRow.value(), asyncViewRow.geometry());
            }
        }).timeout(timeout, timeUnit).toBlocking().getIterator();
    }

    @Override
    public boolean success() {
        return this.asyncViewResult.success();
    }

    @Override
    public JsonObject error() {
        return this.asyncViewResult.error();
    }

    @Override
    public JsonObject debug() {
        return this.asyncViewResult.debug();
    }

    @Override
    public Iterator<SpatialViewRow> iterator() {
        return this.rows();
    }
}

