/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transcoder;

import com.couchbase.client.core.lang.Tuple2;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.error.TranscodingException;
import com.couchbase.client.java.transcoder.Transcoder;

public abstract class AbstractTranscoder<D extends Document<T>, T>
implements Transcoder<D, T> {
    @Override
    public D decode(String id, ByteBuf content, long cas, int expiry, int flags, ResponseStatus status) {
        try {
            D result = this.doDecode(id, content, cas, expiry, flags, status);
            if (content != null && this.shouldAutoReleaseOnDecode()) {
                content.release();
            }
            return result;
        }
        catch (Exception ex) {
            if (content != null && this.shouldAutoReleaseOnError()) {
                content.release();
            }
            if (ex instanceof TranscodingException) {
                throw (TranscodingException)((Object)ex);
            }
            throw new TranscodingException("Could not decode document with ID " + id, ex);
        }
    }

    @Override
    public Tuple2<ByteBuf, Integer> encode(D document) {
        try {
            return this.doEncode(document);
        }
        catch (Exception ex) {
            if (ex instanceof TranscodingException) {
                throw (TranscodingException)((Object)ex);
            }
            throw new TranscodingException("Could not encode document with ID " + document.id(), ex);
        }
    }

    protected abstract D doDecode(String var1, ByteBuf var2, long var3, int var5, int var6, ResponseStatus var7) throws Exception;

    protected abstract Tuple2<ByteBuf, Integer> doEncode(D var1) throws Exception;

    protected boolean shouldAutoReleaseOnDecode() {
        return true;
    }

    protected boolean shouldAutoReleaseOnError() {
        return true;
    }
}

