/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.view.AsyncSpatialViewRow;
import rx.Observable;

public class DefaultAsyncSpatialViewRow
implements AsyncSpatialViewRow {
    private final String id;
    private final JsonArray key;
    private final Object value;
    private final AsyncBucket bucket;
    private final JsonObject geometry;

    public DefaultAsyncSpatialViewRow(AsyncBucket bucket, String id, JsonArray key, Object value, JsonObject geometry) {
        this.bucket = bucket;
        this.id = id;
        this.key = key;
        this.value = value;
        this.geometry = geometry;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public JsonArray key() {
        return this.key;
    }

    @Override
    public Object value() {
        return this.value;
    }

    @Override
    public JsonObject geometry() {
        return this.geometry;
    }

    @Override
    public Observable<JsonDocument> document() {
        if (this.id == null) {
            return Observable.error((Throwable)new UnsupportedOperationException("Document cannot be loaded, id is null."));
        }
        return this.bucket.get(this.id);
    }

    @Override
    public <D extends Document<?>> Observable<D> document(Class<D> target) {
        if (this.id == null) {
            return Observable.error((Throwable)new UnsupportedOperationException("Document cannot be loaded, id is null."));
        }
        return this.bucket.get(this.id, target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AsyncSpatialViewRow{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", key=").append(this.key);
        sb.append(", value=").append(this.value);
        sb.append(", geometry=").append(this.geometry);
        sb.append('}');
        return sb.toString();
    }
}

