/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseCore;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.config.ConfigurationException;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.cluster.DisconnectRequest;
import com.couchbase.client.core.message.cluster.DisconnectResponse;
import com.couchbase.client.core.message.cluster.OpenBucketRequest;
import com.couchbase.client.core.message.cluster.OpenBucketResponse;
import com.couchbase.client.core.message.cluster.SeedNodesRequest;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.ConnectionString;
import com.couchbase.client.java.CouchbaseAsyncBucket;
import com.couchbase.client.java.cluster.AsyncClusterManager;
import com.couchbase.client.java.cluster.DefaultAsyncClusterManager;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.env.DefaultCouchbaseEnvironment;
import com.couchbase.client.java.error.BucketDoesNotExistException;
import com.couchbase.client.java.error.InvalidPasswordException;
import com.couchbase.client.java.transcoder.Transcoder;
import com.couchbase.client.java.util.Bootstrap;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;

public class CouchbaseAsyncCluster
implements AsyncCluster {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(CouchbaseAsyncCluster.class);
    public static final String DEFAULT_BUCKET = "default";
    public static final String DEFAULT_HOST = "127.0.0.1";
    private final ClusterFacade core;
    private final CouchbaseEnvironment environment;
    private final ConnectionString connectionString;
    private final boolean sharedEnvironment;

    public static CouchbaseAsyncCluster create() {
        return CouchbaseAsyncCluster.create(DEFAULT_HOST);
    }

    public static CouchbaseAsyncCluster create(CouchbaseEnvironment environment) {
        return CouchbaseAsyncCluster.create(environment, DEFAULT_HOST);
    }

    public static CouchbaseAsyncCluster create(String ... nodes) {
        return CouchbaseAsyncCluster.create(Arrays.asList(nodes));
    }

    public static CouchbaseAsyncCluster create(List<String> nodes) {
        return new CouchbaseAsyncCluster(DefaultCouchbaseEnvironment.create(), ConnectionString.fromHostnames(nodes), false);
    }

    public static CouchbaseAsyncCluster create(CouchbaseEnvironment environment, String ... nodes) {
        return CouchbaseAsyncCluster.create(environment, Arrays.asList(nodes));
    }

    public static CouchbaseAsyncCluster create(CouchbaseEnvironment environment, List<String> nodes) {
        return new CouchbaseAsyncCluster(environment, ConnectionString.fromHostnames(nodes), true);
    }

    public static CouchbaseAsyncCluster fromConnectionString(String connectionString) {
        return new CouchbaseAsyncCluster(DefaultCouchbaseEnvironment.create(), ConnectionString.create(connectionString), false);
    }

    public static CouchbaseAsyncCluster fromConnectionString(CouchbaseEnvironment environment, String connectionString) {
        return new CouchbaseAsyncCluster(environment, ConnectionString.create(connectionString), true);
    }

    CouchbaseAsyncCluster(CouchbaseEnvironment environment, ConnectionString connectionString, boolean sharedEnvironment) {
        this.sharedEnvironment = sharedEnvironment;
        this.core = new CouchbaseCore((CoreEnvironment)environment);
        SeedNodesRequest request = new SeedNodesRequest(this.assembleSeedNodes(connectionString, environment));
        this.core.send((CouchbaseRequest)request).toBlocking().single();
        this.environment = environment;
        this.connectionString = connectionString;
    }

    private List<String> assembleSeedNodes(ConnectionString connectionString, CouchbaseEnvironment environment) {
        ArrayList<String> seedNodes = new ArrayList<String>();
        if (environment.dnsSrvEnabled()) {
            if (connectionString.hosts().size() == 1) {
                InetSocketAddress lookupNode = connectionString.hosts().get(0);
                LOGGER.debug("Attempting to load DNS SRV records from {}.", (Object)connectionString.hosts().get(0));
                try {
                    List<String> foundNodes = Bootstrap.fromDnsSrv(lookupNode.getHostName(), false, environment.sslEnabled());
                    if (foundNodes.isEmpty()) {
                        throw new IllegalStateException("DNS SRV list is empty.");
                    }
                    seedNodes.addAll(foundNodes);
                    LOGGER.info("Loaded seed nodes from DNS SRV {}.", foundNodes);
                }
                catch (Exception ex) {
                    LOGGER.warn("DNS SRV lookup failed, proceeding with normal bootstrap.", (Throwable)ex);
                    seedNodes.add(lookupNode.getHostName());
                }
            } else {
                LOGGER.info("DNS SRV enabled, but less or more than one seed node given. Proceeding with normal bootstrap.");
                for (InetSocketAddress node : connectionString.hosts()) {
                    seedNodes.add(node.getHostName());
                }
            }
        } else {
            for (InetSocketAddress node : connectionString.hosts()) {
                seedNodes.add(node.getHostName());
            }
        }
        if (seedNodes.isEmpty()) {
            seedNodes.add(DEFAULT_HOST);
        }
        return seedNodes;
    }

    @Override
    public Observable<AsyncBucket> openBucket() {
        return this.openBucket(DEFAULT_BUCKET);
    }

    @Override
    public Observable<AsyncBucket> openBucket(String name) {
        return this.openBucket(name, null);
    }

    @Override
    public Observable<AsyncBucket> openBucket(String name, String pass) {
        return this.openBucket(name, pass, null);
    }

    @Override
    public Observable<AsyncBucket> openBucket(final String name, String pass, List<Transcoder<? extends Document, ?>> transcoders) {
        if (name == null || name.isEmpty()) {
            return Observable.error((Throwable)new IllegalArgumentException("Bucket name is not allowed to be null or empty."));
        }
        final String password = pass == null ? "" : pass;
        final ArrayList trans = transcoders == null ? new ArrayList() : transcoders;
        return Observable.defer((Func0)new Func0<Observable<OpenBucketResponse>>(){

            public Observable<OpenBucketResponse> call() {
                return CouchbaseAsyncCluster.this.core.send((CouchbaseRequest)new OpenBucketRequest(name, password));
            }
        }).map((Func1)new Func1<CouchbaseResponse, AsyncBucket>(){

            public AsyncBucket call(CouchbaseResponse response) {
                if (response.status() != ResponseStatus.SUCCESS) {
                    throw new CouchbaseException("Could not open bucket.");
                }
                return new CouchbaseAsyncBucket(CouchbaseAsyncCluster.this.core, CouchbaseAsyncCluster.this.environment, name, password, trans);
            }
        }).onErrorResumeNext((Func1)new Func1<Throwable, Observable<AsyncBucket>>(){

            public Observable<AsyncBucket> call(Throwable throwable) {
                if (throwable instanceof ConfigurationException) {
                    if (throwable.getCause() instanceof IllegalStateException && throwable.getCause().getMessage().contains("NOT_EXISTS")) {
                        return Observable.error((Throwable)((Object)new BucketDoesNotExistException("Bucket \"" + name + "\" does not exist.")));
                    }
                    if (throwable.getCause() instanceof IllegalStateException && throwable.getCause().getMessage().contains("Unauthorized")) {
                        return Observable.error((Throwable)((Object)new InvalidPasswordException("Passwords for bucket \"" + name + "\" do not match.")));
                    }
                    return Observable.error((Throwable)throwable);
                }
                if (throwable instanceof CouchbaseException) {
                    return Observable.error((Throwable)throwable);
                }
                return Observable.error((Throwable)new CouchbaseException(throwable));
            }
        });
    }

    @Override
    public Observable<Boolean> disconnect() {
        return this.core.send((CouchbaseRequest)new DisconnectRequest()).flatMap((Func1)new Func1<DisconnectResponse, Observable<Boolean>>(){

            public Observable<Boolean> call(DisconnectResponse disconnectResponse) {
                return CouchbaseAsyncCluster.this.sharedEnvironment ? Observable.just((Object)true) : CouchbaseAsyncCluster.this.environment.shutdown();
            }
        });
    }

    @Override
    public Observable<AsyncClusterManager> clusterManager(String username, String password) {
        return Observable.just((Object)DefaultAsyncClusterManager.create(username, password, this.connectionString, this.environment, this.core));
    }

    @Override
    public Observable<ClusterFacade> core() {
        return Observable.just((Object)this.core);
    }
}

