/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.subdoc;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.java.PersistTo;
import com.couchbase.client.java.ReplicateTo;
import com.couchbase.client.java.subdoc.AsyncMutateInBuilder;
import com.couchbase.client.java.subdoc.DocumentFragment;
import com.couchbase.client.java.util.Blocking;
import java.util.concurrent.TimeUnit;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class MutateInBuilder {
    private final long defaultTimeout;
    private final TimeUnit defaultTimeUnit;
    private final AsyncMutateInBuilder asyncBuilder;

    @InterfaceAudience.Private
    public MutateInBuilder(AsyncMutateInBuilder asyncBuilder, long defaultTimeout, TimeUnit defaultTimeUnit) {
        this.asyncBuilder = asyncBuilder;
        this.defaultTimeout = defaultTimeout;
        this.defaultTimeUnit = defaultTimeUnit;
    }

    public DocumentFragment<Mutation> doMutate() {
        return this.doMutate(this.defaultTimeout, this.defaultTimeUnit);
    }

    public DocumentFragment<Mutation> doMutate(long timeout, TimeUnit timeUnit) {
        return Blocking.blockForSingle(this.asyncBuilder.doMutate(), timeout, timeUnit);
    }

    public MutateInBuilder withExpiry(int expiry) {
        this.asyncBuilder.withExpiry(expiry);
        return this;
    }

    public MutateInBuilder withCas(long cas) {
        this.asyncBuilder.withCas(cas);
        return this;
    }

    public MutateInBuilder withDurability(PersistTo persistTo) {
        this.asyncBuilder.withDurability(persistTo);
        return this;
    }

    public MutateInBuilder withDurability(ReplicateTo replicateTo) {
        this.asyncBuilder.withDurability(replicateTo);
        return this;
    }

    public MutateInBuilder withDurability(PersistTo persistTo, ReplicateTo replicateTo) {
        this.asyncBuilder.withDurability(persistTo, replicateTo);
        return this;
    }

    public <T> MutateInBuilder replace(String path, T fragment) {
        this.asyncBuilder.replace(path, fragment);
        return this;
    }

    public <T> MutateInBuilder insert(String path, T fragment, boolean createParents) {
        this.asyncBuilder.insert(path, fragment, createParents);
        return this;
    }

    public <T> MutateInBuilder upsert(String path, T fragment, boolean createParents) {
        this.asyncBuilder.upsert(path, fragment, createParents);
        return this;
    }

    public <T> MutateInBuilder remove(String path) {
        this.asyncBuilder.remove(path);
        return this;
    }

    public MutateInBuilder counter(String path, long delta, boolean createParents) {
        this.asyncBuilder.counter(path, delta, createParents);
        return this;
    }

    public <T> MutateInBuilder pushFront(String path, T value, boolean createParents) {
        this.asyncBuilder.pushFront(path, value, createParents);
        return this;
    }

    public <T> MutateInBuilder pushBack(String path, T value, boolean createParents) {
        this.asyncBuilder.pushBack(path, value, createParents);
        return this;
    }

    public <T> MutateInBuilder arrayInsert(String path, T value) {
        this.asyncBuilder.arrayInsert(path, value);
        return this;
    }

    public <T> MutateInBuilder addUnique(String path, T value, boolean createParents) {
        this.asyncBuilder.addUnique(path, value, createParents);
        return this;
    }

    public String toString() {
        return this.asyncBuilder.toString();
    }
}

