/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.util;

import com.couchbase.client.deps.io.netty.util.ReferenceCounted;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.observers.Subscribers;
import rx.subjects.AsyncSubject;

public class OnSubscribeDeferAndWatch<T>
implements Observable.OnSubscribe<T> {
    private final Func1<Subscriber, ? extends Observable<? extends T>> observableFactory;

    public static <T> Observable<T> deferAndWatch(Func1<Subscriber, ? extends Observable<? extends T>> observableFactory) {
        return Observable.create(new OnSubscribeDeferAndWatch<T>(observableFactory));
    }

    private OnSubscribeDeferAndWatch(Func1<Subscriber, ? extends Observable<? extends T>> observableFactory) {
        this.observableFactory = observableFactory;
    }

    public void call(Subscriber<? super T> s) {
        Observable o;
        try {
            o = (Observable)this.observableFactory.call(s);
        }
        catch (Throwable t) {
            Exceptions.throwOrReport((Throwable)t, s);
            return;
        }
        if (!(o instanceof AsyncSubject)) {
            Exceptions.throwOrReport((Throwable)new IllegalStateException("Only AsyncSubject is allowed with deferAndWatch (is " + o.getClass().getSimpleName() + ")"), s);
            return;
        }
        final AtomicReference<Subscription> sr = new AtomicReference<Subscription>();
        final AtomicBoolean emitted = new AtomicBoolean(false);
        sr.set(o.doOnNext(new Action1<T>(){

            public void call(T t) {
                emitted.set(true);
            }
        }).unsafeSubscribe(Subscribers.wrap(s)));
        o.subscribe(new Subscriber<T>(){

            public void onCompleted() {
            }

            public void onError(Throwable e) {
            }

            public void onNext(T t) {
                ReferenceCounted rc;
                if (t != null && !emitted.get() && ((Subscription)sr.get()).isUnsubscribed() && t instanceof ReferenceCounted && (rc = (ReferenceCounted)t).refCnt() > 0) {
                    rc.release();
                }
            }
        });
    }
}

