/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.element;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.dsl.element.Element;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class IndexElement
implements Element {
    private final String name;
    private final boolean primary;

    public IndexElement(String indexName, boolean forcePrimary) {
        this.name = indexName;
        this.primary = forcePrimary;
    }

    public IndexElement(String indexName) {
        this(indexName, false);
    }

    public IndexElement() {
        this(null, true);
    }

    @Override
    public String export() {
        if (this.primary && this.name == null) {
            return "CREATE PRIMARY INDEX";
        }
        if (this.primary) {
            return "CREATE PRIMARY INDEX `" + this.name + "`";
        }
        return "CREATE INDEX `" + this.name + "`";
    }
}

