/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.config.AlternateAddress;
import com.couchbase.client.core.config.DefaultPortInfo;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.utils.NetworkAddress;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.deps.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public class DefaultAlternateAddress
implements AlternateAddress {
    private final NetworkAddress hostname;
    private final String rawHostname;
    private final Map<ServiceType, Integer> directServices;
    private final Map<ServiceType, Integer> sslServices;

    @JsonCreator
    public DefaultAlternateAddress(@JsonProperty(value="hostname") String hostname, @JsonProperty(value="ports") Map<String, Integer> ports) {
        try {
            this.rawHostname = hostname;
            this.hostname = NetworkAddress.create(this.rawHostname);
        }
        catch (Exception e) {
            throw new CouchbaseException("Could not analyze hostname from config.", e);
        }
        this.directServices = new HashMap<ServiceType, Integer>();
        this.sslServices = new HashMap<ServiceType, Integer>();
        if (ports != null && !ports.isEmpty()) {
            DefaultPortInfo.extractPorts(ports, this.directServices, this.sslServices);
        }
    }

    @Override
    public NetworkAddress hostname() {
        return this.hostname;
    }

    @Override
    public String rawHostname() {
        return this.rawHostname;
    }

    @Override
    public Map<ServiceType, Integer> services() {
        return this.directServices;
    }

    @Override
    public Map<ServiceType, Integer> sslServices() {
        return this.sslServices;
    }

    public String toString() {
        return "DefaultAlternateAddress{hostname=" + this.hostname + ", rawHostname='" + this.rawHostname + '\'' + ", directServices=" + this.directServices + ", sslServices=" + this.sslServices + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAlternateAddress that = (DefaultAlternateAddress)o;
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.rawHostname != null ? !this.rawHostname.equals(that.rawHostname) : that.rawHostname != null) {
            return false;
        }
        if (this.directServices != null ? !this.directServices.equals(that.directServices) : that.directServices != null) {
            return false;
        }
        return this.sslServices != null ? this.sslServices.equals(that.sslServices) : that.sslServices == null;
    }

    public int hashCode() {
        int result = this.hostname != null ? this.hostname.hashCode() : 0;
        result = 31 * result + (this.rawHostname != null ? this.rawHostname.hashCode() : 0);
        result = 31 * result + (this.directServices != null ? this.directServices.hashCode() : 0);
        result = 31 * result + (this.sslServices != null ? this.sslServices.hashCode() : 0);
        return result;
    }
}

