/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.kv;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.endpoint.ResponseStatusConverter;
import com.couchbase.client.core.endpoint.ServerFeatures;
import com.couchbase.client.core.endpoint.ServerFeaturesEvent;
import com.couchbase.client.core.endpoint.kv.ErrorMap;
import com.couchbase.client.core.endpoint.kv.KeyValueStatus;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.utils.DefaultObjectMapper;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.channel.ChannelOutboundHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelPromise;
import com.couchbase.client.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.deps.io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;

public class KeyValueErrorMapHandler
extends SimpleChannelInboundHandler<FullBinaryMemcacheResponse>
implements ChannelOutboundHandler {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(KeyValueErrorMapHandler.class);
    private static final byte GET_ERROR_MAP_CMD = -2;
    private static final short MAP_VERSION = 1;
    private boolean errorMapEnabled;
    private ChannelPromise originalPromise;

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) throws Exception {
        if (KeyValueStatus.SUCCESS.code() == msg.getStatus()) {
            String content = msg.content().toString(CharsetUtil.UTF_8);
            ErrorMap errorMap = DefaultObjectMapper.readValue(content, ErrorMap.class);
            LOGGER.debug("Trying to update Error Map With Version {}, Revision {}.", (Object)errorMap.version(), (Object)errorMap.revision());
            ResponseStatusConverter.updateBinaryErrorMap(errorMap);
            this.originalPromise.setSuccess();
            ctx.pipeline().remove(this);
            ctx.fireChannelActive();
        } else {
            LOGGER.warn("Could not load extended error map, because the server responded with an error. Error code {}", (Object)Integer.toHexString(msg.getStatus()));
            this.originalPromise.setFailure(new CouchbaseException("Could not load extended error map, because the server responded with an error. "));
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.errorMapEnabled) {
            ctx.writeAndFlush(this.errorMapRequest());
        } else {
            this.originalPromise.setSuccess();
            ctx.pipeline().remove(this);
            ctx.fireChannelActive();
        }
    }

    private FullBinaryMemcacheRequest errorMapRequest() {
        LOGGER.debug("Requesting error map in version {}", (Object)1);
        ByteBuf content = Unpooled.buffer(2).writeShort(1);
        DefaultFullBinaryMemcacheRequest request = new DefaultFullBinaryMemcacheRequest(new byte[0], Unpooled.EMPTY_BUFFER, content);
        request.setOpcode((byte)-2);
        request.setTotalBodyLength(content.readableBytes());
        return request;
    }

    @Override
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.originalPromise = promise;
        ChannelPromise downPromise = ctx.newPromise();
        downPromise.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<Void>>(){

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess() && !KeyValueErrorMapHandler.this.originalPromise.isDone()) {
                    KeyValueErrorMapHandler.this.originalPromise.setFailure(future.cause());
                }
            }
        });
        ctx.connect(remoteAddress, localAddress, downPromise);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ServerFeaturesEvent) {
            this.errorMapEnabled = ((ServerFeaturesEvent)evt).supportedFeatures().contains((Object)ServerFeatures.XERROR);
        }
        super.userEventTriggered(ctx, evt);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.disconnect(promise);
    }

    @Override
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close(promise);
    }

    @Override
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        ctx.write(msg, promise);
    }

    @Override
    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    @Override
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }
}

