/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.message.config;

import com.couchbase.client.core.message.AbstractCouchbaseRequest;
import com.couchbase.client.core.message.config.ConfigRequest;

public class GetUsersRequest
extends AbstractCouchbaseRequest
implements ConfigRequest {
    private static final String PATH_PREFIX = "/settings/rbac/users";
    private final String userId;
    private final String domain;

    public static GetUsersRequest users(String username, String password) {
        return new GetUsersRequest(username, password, null, null);
    }

    public static GetUsersRequest usersFromDomain(String username, String password, String domain) {
        return new GetUsersRequest(username, password, domain, null);
    }

    public static GetUsersRequest user(String username, String password, String domain, String userId) {
        return new GetUsersRequest(username, password, domain, userId);
    }

    private GetUsersRequest(String username, String password, String domain, String userId) {
        super(username, password);
        if (!GetUsersRequest.empty(userId) && GetUsersRequest.empty(domain)) {
            throw new IllegalArgumentException("If a userId is supplied the domain must be supplied too!");
        }
        this.userId = userId;
        this.domain = domain;
    }

    @Override
    public String path() {
        String result = PATH_PREFIX;
        if (!GetUsersRequest.empty(this.domain)) {
            result = result + "/" + this.domain;
        }
        if (!GetUsersRequest.empty(this.userId)) {
            result = result + "/" + this.userId;
        }
        return result;
    }

    private static boolean empty(String input) {
        return input == null || input.isEmpty();
    }
}

