/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.message.kv.MutationToken;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.subdoc.DocumentFragment;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class MutationState
implements Iterable<MutationToken> {
    private final List<MutationToken> tokens = new ArrayList<MutationToken>();

    private MutationState() {
    }

    public static MutationState from(Document ... documents) {
        return new MutationState().add(documents);
    }

    public static MutationState from(DocumentFragment ... documentFragments) {
        return new MutationState().add(documentFragments);
    }

    public MutationState add(Document ... documents) {
        if (documents == null || documents.length == 0) {
            throw new IllegalArgumentException("At least one Document must be provided.");
        }
        for (Document d : documents) {
            this.addToken(d.mutationToken());
        }
        return this;
    }

    public MutationState add(DocumentFragment ... documentFragments) {
        if (documentFragments == null || documentFragments.length == 0) {
            throw new IllegalArgumentException("At least one DocumentFragment must be provided.");
        }
        for (DocumentFragment d : documentFragments) {
            this.addToken(d.mutationToken());
        }
        return this;
    }

    public MutationState add(MutationState mutationState) {
        for (MutationToken token : mutationState) {
            this.addToken(token);
        }
        return this;
    }

    private void addToken(MutationToken token) {
        if (token != null) {
            ListIterator<MutationToken> tokenIterator = this.tokens.listIterator();
            while (tokenIterator.hasNext()) {
                MutationToken t = tokenIterator.next();
                if (t.vbucketID() != token.vbucketID() || !t.bucket().equals(token.bucket())) continue;
                if (token.sequenceNumber() > t.sequenceNumber()) {
                    tokenIterator.set(token);
                }
                return;
            }
            this.tokens.add(token);
        }
    }

    @Override
    public Iterator<MutationToken> iterator() {
        return this.tokens.iterator();
    }

    public JsonObject export() {
        JsonObject result = JsonObject.create();
        for (MutationToken token : this.tokens) {
            JsonObject bucket = result.getObject(token.bucket());
            if (bucket == null) {
                bucket = JsonObject.create();
                result.put(token.bucket(), bucket);
            }
            bucket.put(String.valueOf(token.vbucketID()), JsonArray.from(token.sequenceNumber(), String.valueOf(token.vbucketUUID())));
        }
        return result;
    }

    public JsonObject exportForFts() {
        JsonObject result = JsonObject.create();
        for (MutationToken token : this.tokens) {
            String tokenKey = token.vbucketID() + "/" + token.vbucketUUID();
            Long seqno = result.getLong(tokenKey);
            if (seqno != null && seqno >= token.sequenceNumber()) continue;
            result.put(tokenKey, token.sequenceNumber());
        }
        return result;
    }

    public static MutationState from(String source) {
        return MutationState.from(JsonObject.fromJson(source));
    }

    public static MutationState from(JsonObject source) {
        try {
            MutationState state = new MutationState();
            for (String bucketName : source.getNames()) {
                JsonObject bucket = source.getObject(bucketName);
                for (String vbid : bucket.getNames()) {
                    JsonArray values = bucket.getArray(vbid);
                    state.addToken(new MutationToken(Long.parseLong(vbid), Long.parseLong(values.getString(1)), values.getLong(0), bucketName));
                }
            }
            return state;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Could not import MutationState from JSON.", ex);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutationState state = (MutationState)o;
        return this.tokens.containsAll(state.tokens) && state.tokens.containsAll(this.tokens);
    }

    public int hashCode() {
        return this.tokens.hashCode();
    }

    public String toString() {
        return "MutationState{tokens=" + this.tokens + '}';
    }
}

