/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.bucket.api;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.kv.ObserveRequest;
import com.couchbase.client.core.message.kv.ObserveResponse;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.java.bucket.api.Utils;
import com.couchbase.client.java.env.CouchbaseEnvironment;
import com.couchbase.client.java.util.OnSubscribeDeferAndWatch;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Func0;
import rx.functions.Func1;

@InterfaceAudience.Private
@InterfaceStability.Uncommitted
public class Exists {
    public static Observable<Boolean> exists(final String id, final CouchbaseEnvironment environment, final ClusterFacade core, final String bucket, final long timeout, final TimeUnit timeUnit) {
        return Observable.defer((Func0)new Func0<Observable<Boolean>>(){

            public Observable<Boolean> call() {
                final ObserveRequest request = new ObserveRequest(id, 0L, true, 0, bucket);
                Utils.addRequestSpan(environment, request, "exists");
                return Utils.applyTimeout(OnSubscribeDeferAndWatch.deferAndWatch(new Func1<Subscriber, Observable<ObserveResponse>>(){

                    public Observable<ObserveResponse> call(Subscriber s) {
                        request.subscriber(s);
                        return core.send(request);
                    }
                }).map((Func1)new Func1<ObserveResponse, Boolean>(){

                    public Boolean call(ObserveResponse response) {
                        ObserveResponse.ObserveStatus foundStatus;
                        ByteBuf content = response.content();
                        if (content != null && content.refCnt() > 0) {
                            content.release();
                        }
                        if (environment.operationTracingEnabled()) {
                            environment.tracer().scopeManager().activate(response.request().span(), true).close();
                        }
                        return (foundStatus = response.observeStatus()) == ObserveResponse.ObserveStatus.FOUND_PERSISTED || foundStatus == ObserveResponse.ObserveStatus.FOUND_NOT_PERSISTED;
                    }
                }), request, environment, timeout, timeUnit);
            }
        });
    }
}

