/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.view.DesignDocumentNamespace;
import com.couchbase.client.java.view.ViewErrorMode;
import com.couchbase.client.java.view.ViewOrdering;
import com.couchbase.client.java.view.ViewScanConsistency;

public class ViewOptions
extends CommonOptions<ViewOptions> {
    private final UrlQueryStringBuilder params = UrlQueryStringBuilder.createForUrlSafeNames();
    private String keysJson;
    private JsonSerializer serializer;
    private DesignDocumentNamespace namespace;

    public static ViewOptions viewOptions() {
        return new ViewOptions();
    }

    private ViewOptions() {
    }

    public ViewOptions namespace(DesignDocumentNamespace namespace) {
        this.namespace = namespace;
        return this;
    }

    public ViewOptions serializer(JsonSerializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public ViewOptions reduce(boolean reduce) {
        this.params.set("reduce", reduce);
        return this;
    }

    public ViewOptions limit(int limit) {
        if (limit < 0) {
            throw InvalidArgumentException.fromMessage((String)"Limit must be >= 0.");
        }
        this.params.set("limit", limit);
        return this;
    }

    public ViewOptions group(boolean group) {
        this.params.set("group", group);
        return this;
    }

    public ViewOptions groupLevel(int grouplevel) {
        this.params.set("group_level", grouplevel);
        return this;
    }

    public ViewOptions inclusiveEnd(boolean inclusive) {
        this.params.set("inclusive_end", inclusive);
        return this;
    }

    public ViewOptions skip(int skip) {
        if (skip < 0) {
            throw InvalidArgumentException.fromMessage((String)"Skip must be >= 0.");
        }
        this.params.set("skip", skip);
        return this;
    }

    public ViewOptions scanConsistency(ViewScanConsistency scanConsistency) {
        this.params.set("stale", scanConsistency.toString());
        return this;
    }

    public ViewOptions onError(ViewErrorMode viewErrorMode) {
        this.params.set("on_error", viewErrorMode.toString());
        return this;
    }

    public ViewOptions debug(boolean debug) {
        this.params.set("debug", debug);
        return this;
    }

    public ViewOptions order(ViewOrdering ordering) {
        Validators.notNull((Object)((Object)ordering), (String)"ViewOrdering");
        this.params.set("descending", ordering == ViewOrdering.DESCENDING);
        return this;
    }

    public ViewOptions key(String key) {
        this.params.set("key", "\"" + key + "\"");
        return this;
    }

    public ViewOptions key(int key) {
        this.params.set("key", key);
        return this;
    }

    public ViewOptions key(long key) {
        this.params.set("key", key);
        return this;
    }

    public ViewOptions key(double key) {
        this.params.set("key", Double.toString(key));
        return this;
    }

    public ViewOptions key(boolean key) {
        this.params.set("key", key);
        return this;
    }

    public ViewOptions key(JsonObject key) {
        this.params.set("key", key.toString());
        return this;
    }

    public ViewOptions key(JsonArray key) {
        this.params.set("key", key.toString());
        return this;
    }

    public ViewOptions keys(JsonArray keys) {
        this.keysJson = keys.toString();
        return this;
    }

    public ViewOptions startKeyDocId(String id) {
        this.params.set("startkey_docid", id);
        return this;
    }

    public ViewOptions endKeyDocId(String id) {
        this.params.set("endkey_docid", id);
        return this;
    }

    public ViewOptions endKey(String key) {
        this.params.set("endkey", "\"" + key + "\"");
        return this;
    }

    public ViewOptions endKey(int key) {
        this.params.set("endkey", key);
        return this;
    }

    public ViewOptions endKey(long key) {
        this.params.set("endkey", key);
        return this;
    }

    public ViewOptions endKey(double key) {
        this.params.set("endkey", String.valueOf(key));
        return this;
    }

    public ViewOptions endKey(boolean key) {
        this.params.set("endkey", key);
        return this;
    }

    public ViewOptions endKey(JsonObject key) {
        this.params.set("endkey", key.toString());
        return this;
    }

    public ViewOptions endKey(JsonArray key) {
        this.params.set("endkey", key.toString());
        return this;
    }

    public ViewOptions startKey(String key) {
        this.params.set("startkey", "\"" + key + "\"");
        return this;
    }

    public ViewOptions startKey(int key) {
        this.params.set("startkey", key);
        return this;
    }

    public ViewOptions startKey(long key) {
        this.params.set("startkey", key);
        return this;
    }

    public ViewOptions startKey(double key) {
        this.params.set("startkey", String.valueOf(key));
        return this;
    }

    public ViewOptions startKey(boolean key) {
        this.params.set("startkey", key);
        return this;
    }

    public ViewOptions startKey(JsonObject key) {
        this.params.set("startkey", key.toString());
        return this;
    }

    public ViewOptions startKey(JsonArray key) {
        this.params.set("startkey", key.toString());
        return this;
    }

    public ViewOptions raw(String key, String value) {
        this.params.set(key, value);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ViewQuery{");
        sb.append("params=\"").append(this.export()).append('\"');
        if (this.namespace == DesignDocumentNamespace.DEVELOPMENT) {
            sb.append(", dev");
        }
        if (this.keysJson != null) {
            sb.append(", keys=\"");
            if (this.keysJson.length() < 140) {
                sb.append(this.keysJson).append('\"');
            } else {
                sb.append(this.keysJson, 0, 140).append("...\"(").append(this.keysJson.length()).append(" chars total)");
            }
        }
        sb.append('}');
        return sb.toString();
    }

    String export() {
        return this.params.build();
    }

    @Stability.Internal
    public Built build() {
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions {
        Built() {
        }

        public JsonSerializer serializer() {
            return ViewOptions.this.serializer;
        }

        public String keys() {
            return ViewOptions.this.keysJson;
        }

        public boolean development() {
            return ViewOptions.this.namespace == DesignDocumentNamespace.DEVELOPMENT;
        }

        public String query() {
            return ViewOptions.this.export();
        }
    }
}

