/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.request.SuspiciousExpiryDurationEvent;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Stability.Internal
public class Expiry {
    private static final int RELATIVE_EXPIRY_CUTOFF_SECONDS = (int)TimeUnit.DAYS.toSeconds(30L);
    private static final int WORKAROUND_EXPIRY_CUTOFF_SECONDS = (int)TimeUnit.DAYS.toSeconds(365L) * 50;
    private static final Expiry NONE = Expiry.absolute(Instant.ofEpochSecond(0L));
    private final Duration duration;
    private final Instant instant;

    private Expiry(Duration duration, Instant instant) {
        this.duration = duration;
        this.instant = instant;
    }

    public static Expiry none() {
        return NONE;
    }

    public static Expiry relative(Duration expiry) {
        return new Expiry(Objects.requireNonNull(expiry), null);
    }

    public static Expiry absolute(Instant expiry) {
        return new Expiry(null, Objects.requireNonNull(expiry));
    }

    public long encode(EventBus eventBus) {
        if (this.instant != null) {
            return this.instant.getEpochSecond();
        }
        long seconds = this.duration.getSeconds();
        if (seconds < (long)RELATIVE_EXPIRY_CUTOFF_SECONDS) {
            return seconds;
        }
        if (seconds > (long)WORKAROUND_EXPIRY_CUTOFF_SECONDS) {
            eventBus.publish((Event)new SuspiciousExpiryDurationEvent(this.duration));
            return seconds;
        }
        return System.currentTimeMillis() / 1000L + seconds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Expiry{");
        if (this.duration != null) {
            sb.append(this.duration.isZero() ? "none" : this.duration);
        } else {
            sb.append(this.instant.getEpochSecond() == 0L ? "none" : this.instant);
        }
        return sb.append("}").toString();
    }
}

