/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv.projections;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.projections.JsonPathParser;
import com.couchbase.client.core.projections.PathArray;
import com.couchbase.client.core.projections.PathElement;
import com.couchbase.client.core.projections.PathObjectOrField;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.List;

@Stability.Internal
public class ProjectionsApplier {
    private ProjectionsApplier() {
    }

    static Object parseContent(byte[] content) {
        byte first = content[0];
        switch (first) {
            case 123: {
                return JsonObject.fromJson(content);
            }
            case 91: {
                return JsonArray.fromJson(content);
            }
            case 34: {
                String str = new String(content, StandardCharsets.UTF_8);
                return str.substring(1, str.length() - 1);
            }
            case 116: {
                return Boolean.TRUE;
            }
            case 102: {
                return Boolean.FALSE;
            }
            case 110: {
                return null;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                String str = new String(content, StandardCharsets.UTF_8);
                if (str.contains(".")) {
                    return Double.parseDouble(str);
                }
                return Long.parseLong(str);
            }
        }
        return new String(content, StandardCharsets.UTF_8);
    }

    public static JsonObject parse(JsonObject in, String path, byte[] contentRaw) {
        List parsed = JsonPathParser.parse((String)path);
        Object content = ProjectionsApplier.parseContent(contentRaw);
        ProjectionsApplier.parseRecursive(in, parsed, content);
        return in;
    }

    static void parseRecursive(Object out, List<PathElement> path, Object content) {
        if (path.isEmpty()) {
            return;
        }
        if (path.size() == 1) {
            PathElement leaf = path.get(0);
            if (leaf instanceof PathArray) {
                PathArray v = (PathArray)leaf;
                JsonArray toInsert = JsonArray.create().add(content);
                if (out instanceof JsonObject) {
                    ((JsonObject)out).put(v.str(), toInsert);
                } else {
                    ((JsonArray)out).add(toInsert);
                }
            } else {
                PathObjectOrField v = (PathObjectOrField)leaf;
                if (out instanceof JsonObject) {
                    ((JsonObject)out).put(v.str(), content);
                } else {
                    JsonObject toInsert = JsonObject.create();
                    toInsert.put(v.str(), content);
                    ((JsonArray)out).add(toInsert);
                }
            }
        } else {
            PathElement next = path.get(0);
            List<PathElement> remaining = path.subList(1, path.size());
            if (next instanceof PathArray) {
                PathArray v = (PathArray)next;
                JsonArray toInsert = JsonArray.create();
                if (out instanceof JsonObject) {
                    ((JsonObject)out).put(v.str(), toInsert);
                    ProjectionsApplier.parseRecursive(toInsert, remaining, content);
                } else {
                    ((JsonArray)out).add(toInsert);
                    ProjectionsApplier.parseRecursive(out, remaining, content);
                }
            } else {
                PathObjectOrField v = (PathObjectOrField)next;
                if (out instanceof JsonObject) {
                    JsonObject createIn = ((JsonObject)out).getObject(v.str());
                    if (createIn == null) {
                        createIn = JsonObject.create();
                    }
                    ((JsonObject)out).put(v.str(), createIn);
                    ProjectionsApplier.parseRecursive(createIn, remaining, content);
                } else {
                    JsonObject toCreate = JsonObject.create();
                    JsonObject nextToCreate = JsonObject.create();
                    toCreate.put(v.str(), nextToCreate);
                    ((JsonArray)out).add(toCreate);
                    ProjectionsApplier.parseRecursive(nextToCreate, remaining, content);
                }
            }
        }
    }
}

