/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.env;

import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.util.CbObjects;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.codec.DefaultJsonSerializer;
import com.couchbase.client.java.codec.JacksonJsonSerializer;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.JsonTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.env.ClusterPropertyLoader;

public class ClusterEnvironment
extends CoreEnvironment {
    private final JsonSerializer jsonSerializer;
    private final Transcoder transcoder;

    private ClusterEnvironment(Builder builder) {
        super((CoreEnvironment.Builder)builder);
        this.jsonSerializer = (JsonSerializer)CbObjects.defaultIfNull((Object)builder.jsonSerializer, this::newDefaultSerializer);
        this.transcoder = (Transcoder)CbObjects.defaultIfNull((Object)builder.transcoder, () -> JsonTranscoder.create(this.jsonSerializer));
    }

    private JsonSerializer newDefaultSerializer() {
        return this.nonShadowedJacksonPresent() ? JacksonJsonSerializer.create() : DefaultJsonSerializer.create();
    }

    private boolean nonShadowedJacksonPresent() {
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper", false, ((Object)((Object)this)).getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    protected String defaultAgentTitle() {
        return "java";
    }

    public static ClusterEnvironment create() {
        return ClusterEnvironment.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Transcoder transcoder() {
        return this.transcoder;
    }

    public JsonSerializer jsonSerializer() {
        return this.jsonSerializer;
    }

    public static class Builder
    extends CoreEnvironment.Builder<Builder> {
        private JsonSerializer jsonSerializer;
        private Transcoder transcoder;

        Builder() {
        }

        public Builder load(ClusterPropertyLoader loader) {
            Validators.notNull((Object)loader, (String)"ClusterPropertyLoader");
            loader.load(this);
            return this;
        }

        public Builder jsonSerializer(JsonSerializer jsonSerializer) {
            this.jsonSerializer = (JsonSerializer)Validators.notNull((Object)jsonSerializer, (String)"JsonSerializer");
            return this;
        }

        public Builder transcoder(Transcoder transcoder) {
            this.transcoder = (Transcoder)Validators.notNull((Object)transcoder, (String)"Transcoder");
            return this;
        }

        public ClusterEnvironment build() {
            return new ClusterEnvironment(this);
        }
    }
}

